/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.FieldStatsInfo;
import org.apache.solr.client.solrj.response.Group;
import org.apache.solr.client.solrj.response.GroupCommand;
import org.apache.solr.client.solrj.response.GroupResponse;
import org.apache.solr.client.solrj.response.IntervalFacet;
import org.apache.solr.client.solrj.response.PivotField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.RangeFacet;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.client.solrj.response.TermsResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.datamodel.util.AnyUtil;
import org.eclipse.smila.search.api.helper.ResultBuilder;
import org.eclipse.smila.solr.SolrConfig;
import org.eclipse.smila.solr.SolrUtils;
import org.eclipse.smila.solr.administration.FieldInfoCache;

public class ResponseParser
extends ResultBuilder {
    private final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final DataFactory _factory = DataFactory.DEFAULT;
    private final SolrConfig _config;
    private final String _index;

    public ResponseParser(Record record, SolrConfig config, String index) {
        super(record);
        this._config = config;
        this._index = index;
    }

    public Record toRecord(SolrResponse response) {
        if (response instanceof SolrResponseBase) {
            this.parseResponseBase((SolrResponseBase)response);
        }
        if (response instanceof QueryResponse) {
            this.parseQueryResponse((QueryResponse)response);
        }
        return this.getResult();
    }

    public Any toAny(SolrResponse response) {
        return this.toRecord(response).getMetadata();
    }

    private AnyMap getResponseMap() {
        return this._result.getMetadata().getMap("_solr", true).getMap("response", true);
    }

    void parseResponseBase(SolrResponseBase response) {
        NamedList header = response.getResponseHeader();
        if (header != null) {
            AnyMap responseHeader = this.getResponseMap().getMap("responseHeader", true);
            SolrUtils.parseNamedList(header, responseHeader);
        }
    }

    void parseQueryResponse(QueryResponse response) {
        this.parseResults(response);
        this.parseFacets(response);
        this.parseGrouping(response);
        this.parseTerms(response);
        this.parseSpellcheck(response);
        this.parseMoreLikeThis(response);
        this.parseCursorMark(response);
        this.parseDebug(response);
        this.parseStats(response);
    }

    void parseResults(QueryResponse response) {
        SolrDocumentList documents = response.getResults();
        if (documents == null) {
            return;
        }
        long numFound = documents.getNumFound();
        this.setCount(numFound);
        Float maxScore = documents.getMaxScore();
        if (maxScore != null) {
            this.getResponseMap().put("maxScore", (Number)maxScore);
        }
        for (SolrDocument document : documents) {
            AnyMap item = this.createResultItem(document);
            this.getResultRecords().add((Object)item);
            this.parseHighlighting(response, item);
        }
    }

    private AnyMap createResultItem(SolrDocument document) {
        AnyMap item = this.getResultRecords().getFactory().createAnyMap();
        for (Map.Entry entry : document.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Collection) {
                this.addMultiKeyValuePairToItem(item, key, value);
                continue;
            }
            this.addKeyValuePairToItem(item, key, value);
        }
        return item;
    }

    private void addKeyValuePairToItem(AnyMap item, String key, Object value) {
        DataFactory factory = item.getFactory();
        Value autoConvertedValue = factory.autoConvertValue(value);
        item.put(key, (Any)autoConvertedValue);
    }

    private void addMultiKeyValuePairToItem(AnyMap item, String key, Object value) {
        DataFactory factory = item.getFactory();
        Collection multiValues = (Collection)value;
        for (Object multiValue : multiValues) {
            Value autoConvertedValue = factory.autoConvertValue(multiValue);
            item.add(key, (Any)autoConvertedValue);
        }
    }

    private void parseHighlighting(QueryResponse response, AnyMap item) {
        Map highlighting = response.getHighlighting();
        if (highlighting == null) {
            return;
        }
        String id = item.getStringValue(this._config.getIdField(this._index));
        if (id != null) {
            for (Map.Entry entry : ((Map)highlighting.get(id)).entrySet()) {
                String attribute = (String)entry.getKey();
                List text = (List)entry.getValue();
                if (text.size() > 1) {
                    this.addHighlightText(item, attribute, text);
                    continue;
                }
                this.addHighlightText(item, attribute, (String)text.get(0));
            }
        }
    }

    void parseFacets(QueryResponse response) {
        List intervalFacets;
        NamedList pivotFacets;
        Map queryFacets;
        List rangeFacets;
        boolean fetchFacetFieldType = this._config.isFetchFacetFieldType();
        List fieldFacets = response.getFacetFields();
        if (fieldFacets != null) {
            this.addFacetFields(fieldFacets, fetchFacetFieldType);
        }
        if ((rangeFacets = response.getFacetRanges()) != null) {
            this.addFacetRanges(rangeFacets);
        }
        if ((queryFacets = response.getFacetQuery()) != null) {
            this.addFacetQueries(queryFacets);
        }
        if ((pivotFacets = response.getFacetPivot()) != null) {
            this.addFacetPivots((NamedList<List<PivotField>>)pivotFacets);
        }
        if ((intervalFacets = response.getIntervalFacets()) != null) {
            this.addFacetIntervals(intervalFacets);
        }
    }

    private void addFacetFields(List<FacetField> fieldFacets, boolean fetchFacetFieldType) {
        for (FacetField facetField : fieldFacets) {
            String fieldName = facetField.getName();
            AnySeq facet = this.addFacet(fieldName);
            Any.ValueType valueType = this.getFacetFieldType(fieldName);
            for (FacetField.Count countObj : facetField.getValues()) {
                String value = countObj.getName();
                long count = countObj.getCount();
                this.addTypedFacetValue(facet, value, valueType, count);
            }
        }
    }

    private void addFacetRanges(List<RangeFacet> rangeFacets) {
        for (RangeFacet rangeFacet : rangeFacets) {
            String fieldName = rangeFacet.getName();
            AnySeq facet = this.addFacet(fieldName);
            Any.ValueType valueType = this.getFacetFieldType(fieldName);
            for (Object obj : rangeFacet.getCounts()) {
                RangeFacet.Count countObj = (RangeFacet.Count)obj;
                String value = countObj.getValue();
                long count = countObj.getCount();
                this.addTypedFacetValue(facet, value, valueType, count);
            }
        }
    }

    private void addFacetQueries(Map<String, Integer> queryFacets) {
        AnySeq facet = this.addFacet("queries");
        Iterator<String> iterator = queryFacets.keySet().iterator();
        while (iterator.hasNext()) {
            String query;
            String value = query = iterator.next();
            long count = new Long(queryFacets.get(query).intValue());
            this.addFacetValue(facet, value, count);
        }
    }

    private void addFacetPivots(NamedList<List<PivotField>> pivotFacets) {
        AnyMap pivot = this.getResponseMap().getMap("facet_pivot", true);
        SolrUtils.parseNamedList(pivotFacets, pivot);
    }

    private void addFacetIntervals(List<IntervalFacet> intervalFacets) {
        for (IntervalFacet intervalFacet : intervalFacets) {
            String fieldName = intervalFacet.getField();
            AnySeq facet = this.addFacet(fieldName);
            for (IntervalFacet.Count countObj : intervalFacet.getIntervals()) {
                String value = countObj.getKey();
                long count = countObj.getCount();
                this.addFacetValue(facet, value, count);
            }
        }
    }

    private Any.ValueType getFacetFieldType(String fieldName) {
        block3: {
            if (this._config.isFetchFacetFieldType()) {
                try {
                    return FieldInfoCache.getFieldInfo(this._index, fieldName).getTypeAsValueType();
                }
                catch (IOException | InterruptedException exception) {
                    if (!this._log.isWarnEnabled()) break block3;
                    String message = String.format("Error getting value type for fieldName: s%.", fieldName);
                    this._log.warn((Object)message, (Throwable)exception);
                }
            }
        }
        return null;
    }

    private void addTypedFacetValue(AnySeq facet, String value, Any.ValueType valueType, long count) {
        if (valueType != null) {
            this.addFacetValue(facet, value, valueType, count);
        } else {
            Value val = this._factory.autoConvertValue((Object)value);
            this.addFacetValue(facet, (Any)val, count);
        }
    }

    void parseGrouping(QueryResponse response) {
        GroupResponse groupResponse = response.getGroupResponse();
        if (groupResponse == null) {
            return;
        }
        for (GroupCommand command : groupResponse.getValues()) {
            String name = command.getName();
            int matches = command.getMatches();
            AnySeq group = this.addGroup(name, new Long(matches));
            Integer ngroups = command.getNGroups();
            if (ngroups != null) {
                this.getGroups().put("ngroups", (Number)ngroups);
            }
            DataFactory factory = group.getFactory();
            for (Group solrGroup : command.getValues()) {
                Value value = factory.autoConvertValue((Object)solrGroup.getGroupValue());
                SolrDocumentList documents = solrGroup.getResult();
                Long count = documents.getNumFound();
                AnySeq results = factory.createAnySeq();
                for (SolrDocument document : documents) {
                    AnyMap result = this.createResultItem(document);
                    this.parseHighlighting(response, result);
                    results.add((Object)result);
                }
                this.addGroupResults(group, (Any)value, count, results);
            }
        }
    }

    void parseTerms(QueryResponse response) {
        TermsResponse termsResponse = response.getTermsResponse();
        if (termsResponse == null) {
            return;
        }
        AnyMap terms = this.getResponseMap().getMap("terms", true);
        Map termMap = termsResponse.getTermMap();
        for (Map.Entry entry : termMap.entrySet()) {
            AnyMap field = terms.getMap((String)entry.getKey(), true);
            for (TermsResponse.Term term : (List)entry.getValue()) {
                field.put(term.getTerm(), (Number)term.getFrequency());
            }
        }
    }

    void parseSpellcheck(QueryResponse response) {
        List collationList;
        SpellCheckResponse spellcheckResponse = response.getSpellCheckResponse();
        if (spellcheckResponse == null) {
            return;
        }
        AnyMap spellcheck = this.getResponseMap().getMap("spellcheck", true);
        Map suggestionMap = spellcheckResponse.getSuggestionMap();
        if (!MapUtils.isEmpty((Map)suggestionMap)) {
            AnyMap suggestions = spellcheck.getMap("suggestions", true);
            for (Map.Entry entry : suggestionMap.entrySet()) {
                String name = (String)entry.getKey();
                SpellCheckResponse.Suggestion suggestion = (SpellCheckResponse.Suggestion)entry.getValue();
                if (suggestion == null) continue;
                AnyMap map = suggestions.getMap(name, true);
                map.put("numFound", (Number)suggestion.getNumFound());
                map.put("startOffset", (Number)suggestion.getStartOffset());
                map.put("endOffset", (Number)suggestion.getEndOffset());
                map.put("origFreq", (Number)suggestion.getOriginalFrequency());
                List alternatives = suggestion.getAlternatives();
                List alternativeFrequencies = suggestion.getAlternativeFrequencies();
                if (alternativeFrequencies == null) {
                    map.put("suggestion", AnyUtil.objectToAny((Object)alternatives));
                    continue;
                }
                AnySeq extendedResults = map.getSeq("suggestion", true);
                DataFactory factory = extendedResults.getFactory();
                int index = 0;
                for (String word : alternatives) {
                    AnyMap extended = factory.createAnyMap();
                    extended.put("word", word);
                    extended.put("freq", (Number)alternativeFrequencies.get(index));
                    extendedResults.add((Object)extended);
                    ++index;
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(collationList = spellcheckResponse.getCollatedResults()))) {
            AnySeq collations = spellcheck.getSeq("collations", true);
            DataFactory factory = collations.getFactory();
            for (SpellCheckResponse.Collation collationObj : collationList) {
                if (collationObj == null) continue;
                AnyMap collation = factory.createAnyMap();
                collation.put("collationQuery", collationObj.getCollationQueryString());
                collation.put("hits", (Number)collationObj.getNumberOfHits());
                if (!CollectionUtils.isEmpty((Collection)collationObj.getMisspellingsAndCorrections())) {
                    AnyMap misspellingsAndCorrection = collation.getMap("misspellingsAndCorrections", true);
                    for (SpellCheckResponse.Correction correction : collationObj.getMisspellingsAndCorrections()) {
                        misspellingsAndCorrection.put(correction.getOriginal(), correction.getCorrection());
                    }
                }
                collations.add((Object)collation);
            }
        }
    }

    void parseMoreLikeThis(QueryResponse response) {
        Object moreLikeThisObj = response.getResponse().get("moreLikeThis");
        if (moreLikeThisObj != null) {
            AnyMap moreLikeThis = this.getResponseMap().getMap("moreLikeThis", true);
            NamedList relatedDocuments = (NamedList)moreLikeThisObj;
            for (Map.Entry entry : relatedDocuments) {
                String name = (String)entry.getKey();
                AnyMap result = moreLikeThis.getMap(name, true);
                SolrDocumentList documents = (SolrDocumentList)entry.getValue();
                result.put("numFound", (Number)documents.getNumFound());
                result.put("start", (Number)documents.getStart());
                Float maxScore = documents.getMaxScore();
                if (maxScore != null) {
                    result.put("maxScore", (Number)maxScore);
                }
                for (SolrDocument document : documents) {
                    AnyMap item = this.createResultItem(document);
                    result.add("related", (Any)item);
                }
            }
        }
    }

    void parseCursorMark(QueryResponse response) {
        String nextCursorMark = response.getNextCursorMark();
        if (!StringUtils.isEmpty((String)nextCursorMark)) {
            this.getResponseMap().put("nextCursorMark", nextCursorMark);
        }
    }

    void parseDebug(QueryResponse response) {
        Map debugMap = response.getDebugMap();
        if (debugMap != null) {
            AnyMap debug = this.getResponseMap().getMap("debug", true);
            for (Map.Entry entry : debugMap.entrySet()) {
                String name = (String)entry.getKey();
                Object object = entry.getValue();
                if (object instanceof NamedList) {
                    SolrUtils.parseNamedList((NamedList)object, debug.getMap(name, true));
                    continue;
                }
                Value value = debug.getFactory().autoConvertValue(object);
                debug.put(name, (Any)value);
            }
        }
    }

    void parseStats(QueryResponse response) {
        Map fieldStatsInfoMap = response.getFieldStatsInfo();
        if (fieldStatsInfoMap != null) {
            AnyMap stats = this.getResponseMap().getMap("stats", true);
            DataFactory factory = stats.getFactory();
            for (Map.Entry statsEntry : fieldStatsInfoMap.entrySet()) {
                AnyMap field = stats.getMap((String)statsEntry.getKey(), true);
                FieldStatsInfo fieldStatsInfo = (FieldStatsInfo)statsEntry.getValue();
                this.addStats(field, fieldStatsInfo, factory);
                Map facetInfo = fieldStatsInfo.getFacets();
                if (facetInfo == null) continue;
                AnyMap facets = field.getMap("facets", true);
                for (Map.Entry facetsEntry : facetInfo.entrySet()) {
                    AnyMap facet = facets.getMap((String)facetsEntry.getKey(), true);
                    for (FieldStatsInfo facetStatsInfo : (List)facetsEntry.getValue()) {
                        this.addStats(facet, facetStatsInfo, factory);
                    }
                }
            }
        }
    }

    private void addStats(AnyMap stats, FieldStatsInfo fieldStatsInfo, DataFactory factory) {
        stats.put("min", (Any)factory.autoConvertValue(fieldStatsInfo.getMin()));
        stats.put("max", (Any)factory.autoConvertValue(fieldStatsInfo.getMax()));
        stats.put("count", (Number)fieldStatsInfo.getCount());
        stats.put("missing", (Number)fieldStatsInfo.getMissing());
        stats.put("sum", (Any)factory.autoConvertValue(fieldStatsInfo.getSum()));
        stats.put("mean", (Any)factory.autoConvertValue(fieldStatsInfo.getMean()));
        stats.put("stddev", (Number)fieldStatsInfo.getStddev());
    }
}

