/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.search;

import java.net.URLDecoder;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.xml.XmlSerializationUtils;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.util.ResultCollector;
import org.eclipse.smila.solr.SolrConfig;
import org.eclipse.smila.solr.SolrConstants;
import org.eclipse.smila.solr.SolrServerService;
import org.eclipse.smila.solr.params.QueryParams;
import org.eclipse.smila.solr.params.SearchParams;
import org.eclipse.smila.solr.query.QueryTransformer;
import org.eclipse.smila.solr.search.ResponseParser;
import org.eclipse.smila.utils.service.ServiceUtils;

public class SolrSearchPipelet
implements Pipelet {
    private final Log _log = LogFactory.getLog(this.getClass());
    private SolrServerService _servers;
    private AnyMap _configuration;

    public void configure(AnyMap configuration) throws ProcessingException {
        this._configuration = configuration;
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        SearchParams params = new SearchParams(blackboard, this._configuration);
        boolean dropOnError = params.getBooleanParameter("_dropOnError", false);
        ResultCollector results = new ResultCollector((ParameterAccessor)params, this._log, dropOnError);
        String[] stringArray = recordIds;
        int n = recordIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            try {
                params.setCurrentRecord(id);
                QueryParams queryParams = new QueryParams(blackboard, this._configuration, id);
                String index = queryParams.getIndexName();
                if (StringUtils.isBlank((String)index)) {
                    throw new NullArgumentException("indexname");
                }
                SolrQuery query = new QueryTransformer(queryParams, this.getConfig(), index).toSolrQuery();
                SolrConstants.QueryLogging logging = params.getQueryLogging();
                Record record = blackboard.getRecord(id);
                switch (logging) {
                    case SMILA: {
                        this._log.info((Object)("SmilaQueryRecord:" + XmlSerializationUtils.serialize2string((Record)record)));
                        break;
                    }
                    case SOLR: {
                        this._log.info((Object)("SolrQueryString: " + query.toString()));
                        break;
                    }
                    case BOTH: {
                        this._log.info((Object)("SmilaQueryRecord:" + XmlSerializationUtils.serialize2string((Record)record)));
                        this._log.info((Object)("SolrQueryString: " + URLDecoder.decode(query.toString(), "UTF-8")));
                    }
                }
                SolrServer server = this.getServer(index);
                SolrRequest.METHOD method = params.getMethod();
                QueryResponse response = server.query((SolrParams)query, method);
                record = new ResponseParser(record, this.getConfig(), index).toRecord((SolrResponse)response);
                blackboard.setRecord(record);
                results.addResult(id);
            }
            catch (Exception exception) {
                results.addFailedResult(id, exception);
            }
            ++n2;
        }
        return results.getResultIds();
    }

    private SolrServer getServer(String index) throws SolrServerException, InterruptedException {
        if (this._servers == null) {
            this._servers = (SolrServerService)ServiceUtils.getService(SolrServerService.class);
        }
        return this._servers.getServer(index);
    }

    private SolrConfig getConfig() throws InterruptedException {
        if (this._servers == null) {
            this._servers = (SolrServerService)ServiceUtils.getService(SolrServerService.class);
        }
        return this._servers.getConfig();
    }
}

