/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.service;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.common.util.NamedList;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.util.AnyUtil;
import org.eclipse.smila.solr.SolrConfig;
import org.eclipse.smila.solr.SolrOperationService;
import org.eclipse.smila.solr.SolrServerService;
import org.eclipse.smila.solr.SolrUtils;
import org.eclipse.smila.solr.administration.SchemaRequest;
import org.eclipse.smila.solr.administration.SmilaCollectionAdminRequest;
import org.eclipse.smila.solr.administration.SmilaCoreAdminRequest;

public class SolrOperationServiceImpl
implements SolrOperationService {
    private final Log _log = LogFactory.getLog(this.getClass());
    private final HttpClient _httpClient;
    private SolrServerService _serverService;

    public SolrOperationServiceImpl() {
        MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
        this._httpClient = new HttpClient((HttpConnectionManager)manager);
    }

    @Override
    public Any processAdminOperation(String action, Map<String, String[]> params) {
        try {
            Object request = null;
            SolrConfig.Mode mode = this._serverService.getConfig().getMode();
            switch (mode) {
                case CLOUD: {
                    request = new SmilaCollectionAdminRequest(action, params);
                    break;
                }
                case EMBEDDED: 
                case HTTP: {
                    request = new SmilaCoreAdminRequest(action, params);
                    break;
                }
                default: {
                    String message = String.format("Unknown mode: %s", mode.toString());
                    throw new UnsupportedOperationException(message);
                }
            }
            NamedList response = this._serverService.getServer().request((SolrRequest)request);
            return SolrUtils.parseNamedList(response);
        }
        catch (Exception exception) {
            return AnyUtil.exceptionToAny((Throwable)exception);
        }
    }

    @Override
    public Any processPingOperation(String index) {
        try {
            SolrPingResponse response = this._serverService.getServer(index).ping();
            return SolrUtils.parseNamedList(response.getResponse());
        }
        catch (IOException | SolrServerException exception) {
            return AnyUtil.exceptionToAny((Throwable)exception);
        }
    }

    @Override
    public Any processSchemaRequest(String index, Map<String, String[]> params, List<String> path) throws HttpException, IOException {
        SolrConfig.Mode mode = this._serverService.getConfig().getMode();
        switch (mode) {
            case CLOUD: 
            case HTTP: {
                String restUri = this._serverService.getConfig().getRestUri();
                SchemaRequest schemaRequest = new SchemaRequest(this._httpClient, restUri);
                return schemaRequest.getAsAny(index, params, path);
            }
        }
        String message = String.format("Can not process schema request for mode: %s", mode.toString());
        throw new NotImplementedException(message);
    }

    protected void bindSolrServerService(SolrServerService serverService) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Bind SolrServerService...");
        }
        this._serverService = serverService;
    }

    protected void unbindSolrServerService(SolrServerService serverService) {
        if (this._serverService == serverService) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)"Unbind SolrServerService...");
            }
            this._serverService = null;
        }
    }
}

