/**
 *
 */
package org.eclipse.smila.solr.search;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.search.api.helper.ResultAccessor;
import org.eclipse.smila.solr.SolrConstants;
import org.eclipse.smila.solr.params.SolrParams;

/**
 * @author pwissel
 *
 */
public class ResponseAccessor extends ResultAccessor {

  public static final String RESPONSE = "response";

  public ResponseAccessor(Record result) {
    super(result);
  }

  public AnyMap getResponseHeader() {
    return getResponse().getMap(SolrConstants.RESPONSE_HEADER);
  }

  public Integer getStatus() {
    return getResponseHeader().containsKey(SolrConstants.STATUS) ? getResponseHeader().getLongValue(
      SolrConstants.STATUS).intValue() : null;
  }

  public Integer getQTime() {
    return getResponseHeader().containsKey(SolrConstants.Q_TIME) ? getResponseHeader().getLongValue(
      SolrConstants.Q_TIME).intValue() : null;
  }

  public Double getMaxScore() {
    return getResponseHeader().containsKey(SolrConstants.MAX_SCORE) ? getResponseHeader().getDoubleValue(
      SolrConstants.MAX_SCORE) : null;
  }

  public AnySeq getParams() {
    return getResponseHeader().containsKey(SolrConstants.PARAMS) ? getResponseHeader().getSeq(SolrConstants.PARAMS)
      : null;
  }

  public AnyMap getTerms() {
    return getResponse().getMap(SolrConstants.TERMS);
  }

  public AnyMap getSpellcheck() {
    return getResponse().getMap(SolrConstants.SPELLCHECK);
  }

  public AnyMap getMoreLikeThis() {
    return getResponse().getMap(SolrConstants.MORE_LIKE_THIS);
  }

  public String getNextCursorMark() {
    return getResponse().getStringValue(SolrConstants.NEXT_CURSOR_MARK);
  }

  public AnyMap getDebug() {
    return getResponse().getMap(SolrConstants.DEBUG);
  }

  public AnyMap getStats() {
    return getResponse().getMap(SolrConstants.STATS);
  }

  public AnyMap getResponse() {
    return _result.getMetadata().getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE).getMap(RESPONSE);
  }

}
