/*********************************************************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *********************************************************************************************************************/
package org.eclipse.smila.taskworker;

import org.eclipse.smila.common.logging.MessageCollector;

/** write messages as warnings to task log. */
public class TaskLogWarn implements MessageCollector {
  /** reference to the task log. */
  private final TaskLog _taskLog;

  /**
   * TaskLogWarn.
   */
  public TaskLogWarn(final TaskLog taskLog) {
    _taskLog = taskLog;
  }

  @Override
  public void add(final String message) {
    _taskLog.warn(message);
  }
}
