/**********************************************************************************************************************
 * Copyright (c) 2008, 2014 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: Marco Strack (Empolis Information Management GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.scripting.httphandler;

import java.net.MalformedURLException;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.scripting.ScriptingEngine;
import org.eclipse.smila.scripting.ScriptingEngineException;

/**
 * Handles ReST calls for displaying infos about all scripts and functions.
 */
public class ScriptsHandler extends JsonRequestHandler {

  /** The reference to the scripting service. */
  private ScriptingEngine _scriptingEngine;

  /**
   * Set GET instead of POST as basic method.
   */
  @Override
  protected boolean isValidMethod(final String method, final String requestUri) {
    return isGetRequest(method);
  }

  /**
   * accept GET requests.
   */
  protected boolean isGetRequest(final String method) {
    return "GET".equals(method);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object process(final String method, final String requestUri, final Record inputRecord,
    final HttpExchange exchange) throws Exception {
    return getScriptsList(getRequestHost(exchange), requestUri);
  }

  /**
   * create list of pipelines descriptions.
   *
   * @throws ScriptingEngineException
   */
  private Object getScriptsList(final String requestHost, final String baseUri) throws MalformedURLException,
    ScriptingEngineException {
    final AnyMap result = DataFactory.DEFAULT.createAnyMap();
    final AnySeq scripts = FACTORY.createAnySeq();

    final AnySeq itemsSeq = _scriptingEngine.listScripts();
    for (Any singleItem : itemsSeq) {
      final String itemName = singleItem.asMap().getStringValue("name");
      singleItem.asMap().put("url", URLCreator.create(requestHost, baseUri, itemName).toString());
      scripts.add(singleItem);
    }
    result.put("scripts", scripts);

    return result;
  }

  /** set OSGI service. */
  public void setScriptingEngine(final ScriptingEngine scriptingEngine) {
    _scriptingEngine = scriptingEngine;
  }

  /** unset OSGI service. */
  public void unsetScriptingEngine(final ScriptingEngine scriptingEngine) {
    if (_scriptingEngine == scriptingEngine) {
      _scriptingEngine = null;
    }
  }
}
