/**********************************************************************************************************************
 * Copyright (c) 2008, 2014 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Empolis Information Management GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.scripting.internal;

import org.eclipse.smila.scripting.ScriptExecutor.Installable;
import org.eclipse.smila.scripting.ScriptingEngineException;
import org.mozilla.javascript.Scriptable;

/** base class for {@link Installable} that want to install into a Rhino {@link Scriptable} scope. */
public abstract class RhinoInstallable implements Installable {

  @Override
  public void install(final Object installTarget) throws ScriptingEngineException {
    if (installTarget instanceof Scriptable) {
      final Scriptable scope = (Scriptable) installTarget;
      install(scope);
    } else {
      throw new ScriptingEngineException("Cannot install in object of type " + installTarget.getClass());
    }
  }

  /** Installs into Rhino {@link Scriptable} scope. */
  public abstract void install(Scriptable installScope);
}
