/*******************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: Drazen Cindric (Attensity Europe GmbH) - initial API and implementation
 *               Juergen Schumacher (Empolis Information Management GmbH) - refactoring
 *******************************************************************************/
package org.eclipse.smila.processing.httphandler;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.WorkflowProcessor;

/**
 * Implements the handling of HTTP requests for WorkflowProcessor.
 */
public class PipelineProcessHandler extends AProcessHandler {

  /** associated workflow processor. */
  private WorkflowProcessor _processor;

  /** {@inheritDoc} */
  @Override
  public String[] doProcess(final String pipelineName, final Blackboard blackboard, final String[] recordIds)
    throws BlackboardAccessException, ProcessingException {
    return _processor.process(pipelineName, blackboard, recordIds);
  }

  /** set workflow processor reference (used by DS). */
  public void setProcessor(final WorkflowProcessor processor) {
    _processor = processor;
  }

  /** remove workflow processor reference (used by DS). */
  public void unsetProcessor(final WorkflowProcessor processor) {
    if (_processor == processor) {
      _processor = null;
    }
  }
}
