/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.datamodel;

/**
 * Used by AnyUtil to denote errors in conversion between records and Corba Any structures. 
 */
public class AnyConvertException extends Exception {

  /**
   * exceptions are serializable.
   */
  private static final long serialVersionUID = 1L;
  
  /**
   * create exception with message, without causing exception.
   * 
   * @param message
   *          details
   */
  public AnyConvertException(final String message) {
    super(message);
  }

  /**
   * create exception with causing exception.
   * 
   * @param cause
   *          causing exception
   */
  public AnyConvertException(final Throwable cause) {
    super(cause);
  }
  
  /**
   * create exception with message and causing exception.
   * 
   * @param message
   *          details
   * @param cause
   *          causing exception
   */
  public AnyConvertException(final String message, final Throwable cause) {
    super(message, cause);
  }

}
