/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.objectstore.httphandler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.httphandler.AStoreHandler;

public class StoreAdminHandler
extends AStoreHandler {
    public static final String PARAM_RETURNOBJECTS = "returnObjects";
    private final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method) || "PUT".equals(method) || "DELETE".equals(method);
    }

    protected int getSuccessStatus(String method, String requestUri) {
        if ("PUT".equals(method)) {
            return 201;
        }
        if ("DELETE".equals(method)) {
            return 200;
        }
        return super.getSuccessStatus(method, requestUri);
    }

    public Object process(String method, String requestUri, Record parameters) throws ObjectStoreException {
        String storeName = this.getStoreName(requestUri);
        if ("PUT".equals(method)) {
            return this.createStore(storeName, parameters);
        }
        if ("DELETE".equals(method)) {
            return this.deleteStore(storeName);
        }
        return this.getStoreInfo(storeName, parameters);
    }

    private Object createStore(String storeName, Record parameters) throws ObjectStoreException {
        AnyMap storeProperties = null;
        if (parameters == null) {
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Creating store " + storeName + " with default properties."));
            }
        } else {
            storeProperties = parameters.getMetadata();
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Creating store " + storeName + " with properties " + storeProperties.toString()));
            }
        }
        this.getObjectStoreService().createStore(storeName, storeProperties);
        return null;
    }

    private Object deleteStore(String storeName) throws ObjectStoreException {
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("Deleting store " + storeName));
        }
        this.getObjectStoreService().removeStore(storeName);
        return null;
    }

    private AnyMap getStoreInfo(String storeName, Record parameters) throws ObjectStoreException {
        Boolean returnObjectsValue;
        boolean returnObjects = true;
        if (parameters != null && parameters.getMetadata() != null && (returnObjectsValue = parameters.getMetadata().getBooleanValue(PARAM_RETURNOBJECTS)) != null) {
            returnObjects = returnObjectsValue;
        }
        return this.getObjectStoreService().getStoreInfo(storeName, returnObjects);
    }
}

