/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.lang.reflect.Modifier;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SQLToJavaValueNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class NonStaticMethodCallNode
extends MethodCallNode {
    JavaValueNode receiver;
    private boolean isStatic;

    public void init(Object methodName, Object receiver) throws StandardException {
        super.init(methodName);
        this.receiver = receiver instanceof JavaToSQLValueNode ? ((JavaToSQLValueNode)receiver).getJavaValueNode() : (JavaValueNode)this.getNodeFactory().getNode(28, receiver, this.getContextManager());
    }

    public JavaValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        boolean nullParameter = false;
        if (this.receiver instanceof SQLToJavaValueNode) {
            ValueNode SQLValue = ((SQLToJavaValueNode)this.receiver).getSQLValueNode();
            SanityManager.ASSERT(!(SQLValue instanceof UntypedNullConstantNode), "UntypedNullConstantNode found as a receiver of a non-static method call");
            if (SQLValue.requiresTypeFromContext() && SQLValue.getTypeServices() == null) {
                throw StandardException.newException("42X54", this.methodName);
            }
        }
        this.bindParameters(fromList, subqueryList, aggregateVector);
        this.receiver = this.receiver.bindExpression(fromList, subqueryList, aggregateVector);
        String type = this.receiver.getJSQLType().getSQLType().getTypeId().getSQLTypeName();
        if (type.equals("BLOB") || type.equals("CLOB") || type.equals("NCLOB")) {
            throw StandardException.newException("XJ082.U");
        }
        this.javaClassName = this.receiver.getJavaTypeName();
        if (ClassInspector.primitiveType(this.javaClassName)) {
            throw StandardException.newException("42X52", (Object)this.methodName, (Object)this.javaClassName);
        }
        this.resolveMethodCall(this.javaClassName, false);
        this.isStatic = Modifier.isStatic(this.method.getModifiers());
        return this;
    }

    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        if (simplePredsOnly) {
            return false;
        }
        boolean pushable = true;
        boolean bl = pushable = pushable && super.categorize(referencedTabs, simplePredsOnly);
        if (this.receiver != null) {
            pushable = pushable && this.receiver.categorize(referencedTabs, simplePredsOnly);
        }
        return pushable;
    }

    protected int getOrderableVariantType() throws StandardException {
        int thisVariant;
        int receiverVariant = this.receiver.getOrderableVariantType();
        if (receiverVariant > 1 && this.receiver.getJavaTypeName().equals("org.apache.derby.iapi.db.TriggerExecutionContext")) {
            receiverVariant = 1;
        }
        if (receiverVariant < (thisVariant = super.getOrderableVariantType())) {
            return receiverVariant;
        }
        return thisVariant;
    }

    public JavaValueNode remapColumnReferencesToExpressions() throws StandardException {
        if (this.receiver != null) {
            this.receiver.remapColumnReferencesToExpressions();
        }
        return super.remapColumnReferencesToExpressions();
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.receiver != null) {
            this.printLabel(depth, "receiver :");
            this.receiver.treePrint(depth + 1);
        }
    }

    public void preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        super.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        this.receiver.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        Class<?> declaringClass;
        boolean inConditional = false;
        if (!this.valueReturnedToSQLDomain() && !this.returnValueDiscarded() && this.generateReceiver(acb, mb, this.receiver)) {
            inConditional = true;
            mb.conditionalIfNull();
            mb.pushNull(this.getJavaTypeName());
            mb.startElseCode();
        }
        short methodType = (declaringClass = this.method.getDeclaringClass()).isInterface() ? (short)185 : (this.isStatic ? (short)184 : 182);
        this.getReceiverExpression(acb, mb, this.receiver);
        if (this.isStatic) {
            mb.endStatement();
        }
        int nargs = this.generateParameters(acb, mb);
        mb.callMethod(methodType, declaringClass.getName(), this.methodName, this.getJavaTypeName(), nargs);
        if (inConditional) {
            mb.completeConditional();
        }
    }

    protected boolean generateReceiver(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.isStatic) {
            return false;
        }
        return this.generateReceiver(acb, mb, this.receiver);
    }

    public Visitable accept(Visitor v) throws StandardException {
        if (v.skipChildren(this)) {
            return v.visit(this);
        }
        Visitable returnNode = super.accept(v);
        if (this.receiver != null && !v.stopTraversal()) {
            this.receiver = (JavaValueNode)this.receiver.accept(v);
        }
        return returnNode;
    }
}

