/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.test;

import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.eclipse.smila.test.DeclarativeServiceTestCase;

public abstract class JmxTestCase
extends DeclarativeServiceTestCase {
    protected static final String DOMAIN = "SMILA";
    protected MBeanServerConnection _mbeanServer;

    protected void setUp() throws Exception {
        String port = System.getProperty("com.sun.management.jmxremote.port");
        JmxTestCase.assertNotNull((String)"com.sun.management.jmxremote.port system property is not set", (Object)port);
        JMXServiceURL jmxUrl = new JMXServiceURL(String.format("service:jmx:rmi:///jndi/rmi://localhost:%s/jmxrmi", port));
        this._mbeanServer = JMXConnectorFactory.connect(jmxUrl).getMBeanServerConnection();
    }

    protected void tearDown() throws Exception {
        this._mbeanServer = null;
        super.tearDown();
    }

    protected Object method(String domain, String key, String operation, Object[] arguments, String[] signature) {
        try {
            ObjectName objectName = this.prepareObjectName(domain, key);
            return this._mbeanServer.invoke(objectName, operation, arguments, signature);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected Object method(String key, String operation, Object[] arguments, String[] signature) {
        return this.method(DOMAIN, key, operation, arguments, signature);
    }

    protected Object methodArgumentString(String key, String operation, String argument) {
        return this.method(DOMAIN, key, operation, new Object[]{argument}, new String[]{String.class.getName()});
    }

    protected Object attribute(String domain, String key, String attribute) {
        try {
            ObjectName objectName = this.prepareObjectName(domain, key);
            return this._mbeanServer.getAttribute(objectName, attribute);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected Object attribute(String key, String attribute) {
        return this.attribute(DOMAIN, key, attribute);
    }

    private ObjectName prepareObjectName(String domain, String key) throws MalformedObjectNameException {
        if (!key.contains("=")) {
            String[] parts = key.split("/");
            key = "";
            int i = 0;
            while (i < parts.length - 1) {
                key = String.valueOf(key) + String.format("C%d=%s,", i, parts[i]);
                ++i;
            }
            key = String.valueOf(key) + "Agent=" + parts[parts.length - 1];
        }
        return new ObjectName(String.valueOf(domain) + ":" + key);
    }
}

