/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.tika.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.eclipse.smila.common.mimetype.MimeTypeIdentifier;
import org.eclipse.smila.common.mimetype.MimeTypeParseException;
import org.eclipse.smila.tika.internal.TemporaryResourcesHelper;

public class TikaMimeTypeIdentifyService
implements MimeTypeIdentifier {
    private Detector _detector;

    public String identify(byte[] data) throws MimeTypeParseException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayInputStream dataStream = new ByteArrayInputStream(data);){
                return this.identify(dataStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new MimeTypeParseException("Error while detecting mimetype.", (Throwable)e);
        }
    }

    public String identify(InputStream dataStream) throws MimeTypeParseException {
        return this.identify(dataStream, null);
    }

    public String identify(String extension) throws MimeTypeParseException {
        return this.identify((InputStream)null, extension);
    }

    public String identify(byte[] data, String extension) throws MimeTypeParseException {
        if (data == null) {
            return this.identify((InputStream)null, extension);
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ByteArrayInputStream dataStream = new ByteArrayInputStream(data);){
                return this.identify(dataStream, extension);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new MimeTypeParseException("Error while detecting mimetype.", (Throwable)e);
        }
    }

    public String identify(InputStream dataStream, String extension) throws MimeTypeParseException {
        InputStream resettableInputStream;
        Metadata metadata = new Metadata();
        TemporaryResources tmp = null;
        if (dataStream == null || dataStream instanceof TikaInputStream) {
            resettableInputStream = dataStream;
        } else {
            tmp = new TemporaryResources();
            resettableInputStream = TikaInputStream.get((InputStream)dataStream, (TemporaryResources)tmp);
        }
        if (extension != null && !extension.isEmpty()) {
            metadata.add("resourceName", "dummy." + extension);
        }
        try {
            MediaType mt = this._detector.detect(resettableInputStream, metadata);
            String string = mt.getBaseType().toString();
            return string;
        }
        catch (IOException e) {
            throw new MimeTypeParseException("Error while detecting mimetype.", (Throwable)e);
        }
        finally {
            TemporaryResourcesHelper.disposeQuietly(tmp);
        }
    }

    public Detector getDetector() {
        return this._detector;
    }

    public void setDetector(Detector detector) {
        this._detector = detector;
    }

    public void unsetDetector(Detector detector) {
        if (this._detector == detector) {
            this._detector = null;
        }
    }
}

