/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.log;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public final class BundleLogHelper {
    private static final Map<Integer, String> DESCRIPTIONS = new HashMap<Integer, String>();

    static {
        DESCRIPTIONS.put(32, "ACTIVE     ");
        DESCRIPTIONS.put(2, "INSTALLED  ");
        DESCRIPTIONS.put(4, "RESOLVED   ");
        DESCRIPTIONS.put(2, "START ACTIVATION POLICY");
        DESCRIPTIONS.put(1, "START TRANSIENT");
        DESCRIPTIONS.put(8, "STARTING...");
        DESCRIPTIONS.put(1, "STOP TRANSIENT");
        DESCRIPTIONS.put(16, "STOPPING...");
        DESCRIPTIONS.put(1, "UNINSTALLED");
    }

    private BundleLogHelper() {
    }

    public static void logBundlesState() {
        Log log = LogFactory.getLog(BundleLogHelper.class);
        StringBuilder result = new StringBuilder();
        Bundle[] bundleArray = Platform.getBundle((String)"org.eclipse.core.runtime").getBundleContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            String state = DESCRIPTIONS.get(bundle.getState());
            result.append(String.format("%n%3d %s %s", bundle.getBundleId(), state, bundle.getSymbolicName()));
            ++n2;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)result.toString());
        }
    }
}

