/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskmanager;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyConvertException;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.taskmanager.TaskCompletionStatus;

public class ResultDescription {
    public static final String KEY_STATUS = "status";
    public static final String KEY_ERROR_CODE = "errorCode";
    public static final String KEY_COUNTERS = "counters";
    public static final String KEY_ERROR_MESSAGE = "errorMessage";
    private final TaskCompletionStatus _status;
    private final String _errorCode;
    private final String _errorMessage;
    private final Map<String, Number> _counters;

    public ResultDescription(TaskCompletionStatus status, String errorCode, String errorMessage, Map<String, Number> counters) {
        this._status = status;
        this._errorCode = errorCode;
        this._errorMessage = errorMessage;
        this._counters = counters != null ? counters : new HashMap<String, Number>();
    }

    public static ResultDescription fromAny(AnyMap resultDescriptionAny) throws AnyConvertException {
        try {
            LinkedHashMap<String, Number> counters;
            TaskCompletionStatus status = TaskCompletionStatus.valueOf(resultDescriptionAny.getStringValue(KEY_STATUS));
            String errorCode = resultDescriptionAny.get((Object)KEY_ERROR_CODE) != null ? resultDescriptionAny.getStringValue(KEY_ERROR_CODE) : null;
            String errorMessage = resultDescriptionAny.get((Object)KEY_ERROR_MESSAGE) != null ? resultDescriptionAny.getStringValue(KEY_ERROR_MESSAGE) : null;
            if (resultDescriptionAny.get((Object)KEY_COUNTERS) != null) {
                counters = new LinkedHashMap<String, Number>();
                AnyMap countersAny = resultDescriptionAny.getMap(KEY_COUNTERS);
                for (Map.Entry entry : countersAny.entrySet()) {
                    Number number;
                    String key = (String)entry.getKey();
                    Any anyValue = (Any)entry.getValue();
                    if (anyValue.isDouble()) {
                        number = ((Value)anyValue).asDouble();
                    } else if (anyValue.isLong()) {
                        number = ((Value)anyValue).asLong();
                    } else {
                        throw new AnyConvertException("Invalid Any type '" + anyValue.getValueType() + "' for counter '" + key + "'.");
                    }
                    counters.put(key, number);
                }
            } else {
                counters = null;
            }
            return new ResultDescription(status, errorCode, errorMessage, counters);
        }
        catch (Exception ex) {
            throw new AnyConvertException("Error parsing ResultDescription from Any object", (Throwable)ex);
        }
    }

    public TaskCompletionStatus getStatus() {
        return this._status;
    }

    public String getErrorCode() {
        return this._errorCode;
    }

    public String getErrorMessage() {
        return this._errorMessage;
    }

    public Map<String, Number> getCounters() {
        return this._counters;
    }

    public AnyMap toAny() throws Exception {
        AnyMap result = DataFactory.DEFAULT.createAnyMap();
        result.put(KEY_STATUS, this._status.name());
        if (this._errorCode != null) {
            result.put(KEY_ERROR_CODE, this._errorCode);
        }
        if (this._errorMessage != null) {
            result.put(KEY_ERROR_MESSAGE, this._errorMessage);
        }
        if (this._counters != null) {
            AnyMap anyCounters = DataFactory.DEFAULT.createAnyMap();
            for (Map.Entry<String, Number> entry : this._counters.entrySet()) {
                Number number = entry.getValue();
                anyCounters.put(entry.getKey(), number);
            }
            result.put(KEY_COUNTERS, (Any)anyCounters);
        }
        return result;
    }
}

