/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.file;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.importing.crawler.file.FileCrawlerService;
import org.eclipse.smila.importing.util.PropertyNameMapper;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.RecordOutput;

public class FileFetcherWorker
implements Worker {
    public static final String NAME = "fileFetcher";
    public static final String INPUT_SLOT = "filesToFetch";
    public static final String OUTPUT_SLOT = "files";
    private final Log _log = LogFactory.getLog(this.getClass());
    private FileCrawlerService _fileCrawler;

    public String getName() {
        return NAME;
    }

    public void perform(TaskContext taskContext) throws Exception {
        Record record;
        RecordInput recordInput = taskContext.getInputs().getAsRecordInput(INPUT_SLOT);
        RecordOutput recordOutput = taskContext.getOutputs().getAsRecordOutput(OUTPUT_SLOT);
        do {
            if ((record = recordInput.getRecord()) == null) continue;
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("fetching content for record " + record.getId()));
            }
            this.fetch(record, taskContext);
            recordOutput.writeRecord(record);
            if (!this._log.isDebugEnabled()) continue;
            this._log.debug((Object)("added record " + record.getId()));
        } while (record != null && !taskContext.isCanceled());
    }

    private void fetch(Record record, TaskContext taskContext) throws IOException {
        PropertyNameMapper mapper = PropertyNameMapper.createFrom((TaskContext)taskContext);
        String pathAttribute = "filePath";
        if (mapper.containsMapping("filePath")) {
            pathAttribute = (String)mapper.get("filePath").get(0);
        }
        this.fillFileContent(mapper, taskContext, record, pathAttribute);
        this.fillMissingMetadata(mapper, taskContext, record, pathAttribute);
    }

    private void fillFileContent(PropertyNameMapper mapper, TaskContext taskContext, Record record, String pathAttribute) {
        try {
            for (String attachmentName : mapper.get("fileContent")) {
                if (record.hasAttachment(attachmentName)) continue;
                long time = taskContext.getTimestamp();
                this._fileCrawler.addAttachment(record, pathAttribute, attachmentName);
                taskContext.measureTime("fetchContent", time);
            }
        }
        catch (IOException | RuntimeException e) {
            taskContext.getLog().warn("Failed to fetch content for record " + record.getId(), (Throwable)e);
        }
    }

    private void fillMissingMetadata(PropertyNameMapper mapper, TaskContext taskContext, Record record, String pathAttribute) {
        AnyMap metadata = record.getMetadata();
        try {
            Record mdRecord = this._fileCrawler.fileToRecord(Paths.get(metadata.getStringValue(pathAttribute), new String[0]), record.getSource(), false);
            Set<String> propertyNames = this._fileCrawler.getFilePropertyNames();
            for (String property : propertyNames) {
                if ("fileContent".equals(property) || !mapper.containsMapping(property)) continue;
                for (String attributeName : mapper.get(property)) {
                    if (metadata.containsKey((Object)attributeName) || !mdRecord.getMetadata().containsKey((Object)property)) continue;
                    metadata.put(attributeName, (Any)mdRecord.getMetadata().get((Object)property));
                }
            }
        }
        catch (IOException | RuntimeException e) {
            taskContext.getLog().warn("Failed to get metadata from file for record " + record.getId(), (Throwable)e);
        }
    }

    public void setFileCrawlerService(FileCrawlerService fileCrawler) {
        this._fileCrawler = fileCrawler;
    }

    public void unsetFileCrawlerService(FileCrawlerService fileCrawler) {
        if (this._fileCrawler == fileCrawler) {
            this._fileCrawler = null;
        }
    }
}

