/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.params;

import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrRequest;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.util.AnyUtil;
import org.eclipse.smila.solr.params.UpdateParams;

public class ParamsHelper {
    private ParamsHelper() {
    }

    public static Any setSubParam(Record target, String subMapName, String key, Object value) {
        return ParamsHelper.setSubParam(target.getMetadata(), subMapName, key, value);
    }

    public static Any setSubParam(AnyMap target, String subMapName, String key, Object value) {
        Any val = ParamsHelper.convertToAny(key, value);
        return ParamsHelper.getSub(target, subMapName).put(key, val);
    }

    public static Any setSolrParam(Record target, String key, Object value) {
        return ParamsHelper.setSolrParam(target.getMetadata(), key, value);
    }

    public static Any setSolrParam(AnyMap target, String key, Object value) {
        Any val = ParamsHelper.convertToAny(key, value);
        return ParamsHelper.getSolr(target).put(key, val);
    }

    public static Any setRootParam(Record target, String key, Object value) {
        return ParamsHelper.setRootParam(target.getMetadata(), key, value);
    }

    public static Any setRootParam(AnyMap target, String key, Object value) {
        Any val = ParamsHelper.convertToAny(key, value);
        return ParamsHelper.getRoot(target).put(key, val);
    }

    private static AnyMap getSub(AnyMap target, String sub) {
        return ParamsHelper.getSolr(target).getMap(sub, true);
    }

    private static AnyMap getSolr(AnyMap target) {
        return ParamsHelper.getRoot(target).getMap("_solr", true);
    }

    private static AnyMap getRoot(AnyMap target) {
        if (target == null) {
            throw new IllegalArgumentException("Target must not be null.");
        }
        return target;
    }

    private static Any convertToAny(String key, Object value) {
        if (StringUtils.isBlank((String)key)) {
            throw new IllegalArgumentException("Key must not be blank.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null.");
        }
        return AnyUtil.objectToAny((Object)value);
    }

    public static Any setUpdateAttachments(Record target, boolean attachments) {
        return ParamsHelper.setUpdateAttachments(target.getMetadata(), attachments);
    }

    public static Any setUpdateAttachments(AnyMap target, boolean attachments) {
        return ParamsHelper.setSubParam(target, "update", "attachments", (Object)attachments);
    }

    public static Any setUpdateCommitWithinMs(Record target, int commitWithinMs) {
        return ParamsHelper.setUpdateCommitWithinMs(target.getMetadata(), commitWithinMs);
    }

    public static Any setUpdateCommitWithinMs(AnyMap target, int commitWithinMs) {
        return ParamsHelper.setSubParam(target, "update", "commitWithinMs", (Object)commitWithinMs);
    }

    public static Any setUpdateDocumentBoost(Record target, float documentBoost) {
        return ParamsHelper.setUpdateDocumentBoost(target.getMetadata(), documentBoost);
    }

    public static Any setUpdateDocumentBoost(AnyMap target, float documentBoost) {
        return ParamsHelper.setSubParam(target, "update", "documentBoost", (Object)Float.valueOf(documentBoost));
    }

    public static Any setUpdateMapping(Record target, AnyMap mapping) {
        return ParamsHelper.setUpdateMapping(target.getMetadata(), mapping);
    }

    public static Any setUpdateMapping(AnyMap target, AnyMap mapping) {
        return ParamsHelper.setSubParam(target, "update", "mapping", (Object)mapping);
    }

    public static Any setUpdateOperation(Record target, UpdateParams.Operation operation) {
        return ParamsHelper.setUpdateOperation(target.getMetadata(), operation);
    }

    public static Any setUpdateOperation(AnyMap target, UpdateParams.Operation operation) {
        return ParamsHelper.setSubParam(target, "update", "operation", (Object)operation.toString());
    }

    public static Any setUpdateDeleteQuery(Record target, String deleteQuery) {
        return ParamsHelper.setUpdateDeleteQuery(target.getMetadata(), deleteQuery);
    }

    public static Any setUpdateDeleteQuery(AnyMap target, String deleteQuery) {
        return ParamsHelper.setSubParam(target, "update", "deleteQuery", (Object)deleteQuery);
    }

    public static Any setUpdateIndexName(Record target, String index) {
        return ParamsHelper.setUpdateIndexName(target.getMetadata(), index);
    }

    public static Any setUpdateIndexName(AnyMap target, String index) {
        return ParamsHelper.setRootParam(target, "indexname", (Object)index);
    }

    public static Any setSearchMethod(Record target, SolrRequest.METHOD method) {
        return ParamsHelper.setSearchMethod(target.getMetadata(), method);
    }

    public static Any setSearchMethod(AnyMap target, SolrRequest.METHOD method) {
        return ParamsHelper.setSubParam(target, "search", "method", (Object)method.toString());
    }
}

