/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.search.api.QueryConstants;
import org.eclipse.smila.solr.SolrConfig;
import org.eclipse.smila.solr.SolrConstants;
import org.eclipse.smila.solr.SolrUtils;
import org.eclipse.smila.solr.params.QueryParams;

public class QueryTransformer {
    private final Log _log = LogFactory.getLog(this.getClass());
    private final QueryParams _params;
    private final SolrConfig _config;
    private final String _index;
    private final Map<String, FilterGroup> _groupedFilters;
    private final StringBuilder _buffer = new StringBuilder(4095);

    public QueryTransformer(QueryParams params, SolrConfig config, String index) {
        this._params = params;
        this._config = config;
        this._index = index;
        this._groupedFilters = LazyMap.decorate(new HashMap(), (Factory)new Factory(){

            public Object create() {
                return new FilterGroup();
            }
        });
    }

    public SolrQuery toSolrQuery() {
        return this.toSolrQuery(new SolrQuery());
    }

    public SolrQuery toSolrQuery(SolrQuery solrQuery) {
        this.addCommonQueryParameters(solrQuery);
        this.addQuery(solrQuery);
        this.addHighlighting(solrQuery);
        this.addSorting(solrQuery);
        this.addFaceting(solrQuery);
        this.addGrouping(solrQuery);
        this.addFilters(solrQuery);
        this.addNativeParams(solrQuery);
        return solrQuery;
    }

    SolrQuery addCommonQueryParameters(SolrQuery solrQuery) {
        String idField;
        String qt;
        int start = this._params.getStart();
        solrQuery.setStart(Integer.valueOf(start));
        int rows = this._params.getRows();
        solrQuery.setRows(Integer.valueOf(rows));
        Object[] fields = this._params.getFields();
        if (!ArrayUtils.isEmpty((Object[])fields)) {
            solrQuery.setFields((String[])fields);
        }
        if ((qt = this._params.getRequestHandler()) != null) {
            solrQuery.setRequestHandler(qt);
        }
        if (this._params.hasHighlightConfig() && !ArrayUtils.contains((Object[])fields, (Object)(idField = this._config.getIdField(this._index)))) {
            solrQuery.addField(idField);
        }
        return solrQuery;
    }

    SolrQuery addQuery(SolrQuery solrQuery) {
        Any query = this._params.getQueryObject();
        if (query != null) {
            if (query.isValue()) {
                String queryString = query.asValue().asString();
                solrQuery.setQuery(queryString);
            } else if (query.isSeq()) {
                String queryString = StringUtils.join((Collection)query.asSeq().asStrings(), (String)" ");
                solrQuery.setQuery(queryString);
            } else if (query.isMap()) {
                AnyMap queryObj = query.asMap();
                StringBuilder queryString = new StringBuilder();
                Any localParams = (Any)queryObj.remove((Object)"localParams");
                if (localParams != null && localParams.isMap()) {
                    SolrUtils.writeLocalParams(queryString, localParams.asMap());
                }
                for (Map.Entry queryPart : queryObj.entrySet()) {
                    this.addFieldedQueryPart(queryString, (String)queryPart.getKey(), (Any)queryPart.getValue());
                }
                solrQuery.setQuery(queryString.toString());
            }
        }
        return solrQuery;
    }

    private void addFieldedQueryPart(StringBuilder queryString, String field, Any values) {
        if (queryString.length() > 0) {
            queryString.append(" ");
        }
        queryString.append(field).append(":");
        if (values.isValue()) {
            queryString.append(values.asValue().asString());
        } else if (values.isSeq() && values.asSeq().size() > 1) {
            StringBuilder multiValue = new StringBuilder();
            multiValue.append("(");
            for (String value : values.asSeq().asStrings()) {
                if (multiValue.length() > 1) {
                    multiValue.append(" ");
                }
                multiValue.append(value);
            }
            multiValue.append(")");
            queryString.append((CharSequence)multiValue);
        }
    }

    SolrQuery addNativeParams(SolrQuery solrQuery) {
        AnyMap nativeParams = this._params.getNativeParams();
        if (nativeParams != null && !nativeParams.isEmpty()) {
            for (String name : nativeParams.keySet()) {
                Any value = (Any)nativeParams.get((Object)name);
                if (value == null) continue;
                if (value.isValue()) {
                    solrQuery.add(name, new String[]{value.asValue().asString()});
                    continue;
                }
                if (!value.isSeq()) continue;
                List strings = value.asSeq().asStrings();
                String[] values = strings.toArray(new String[strings.size()]);
                solrQuery.add(name, values);
            }
        }
        return solrQuery;
    }

    SolrQuery addHighlighting(SolrQuery solrQuery) {
        AnySeq highlight = this._params.getHighlightConfig();
        if (highlight != null && !highlight.isEmpty()) {
            for (Any any : highlight) {
                if (any.isValue()) {
                    solrQuery.addHighlightField(any.asValue().asString());
                    continue;
                }
                if (!any.isMap()) continue;
                solrQuery.addHighlightField(any.asMap().getStringValue("attribute"));
            }
        }
        return solrQuery;
    }

    SolrQuery addSorting(SolrQuery solrQuery) {
        List sortByConfig = this._params.getSortByConfig();
        if (sortByConfig != null && !sortByConfig.isEmpty()) {
            for (AnyMap sortBy : sortByConfig) {
                String field = sortBy.getStringValue("attribute");
                String sortOrderValue = sortBy.getStringValue("order");
                QueryConstants.SortOrder sortOrder = QueryConstants.SortOrder.valueOf((String)sortOrderValue.toUpperCase());
                switch (sortOrder) {
                    case ASCENDING: {
                        solrQuery.addSort(field, SolrQuery.ORDER.asc);
                        break;
                    }
                    case DESCENDING: {
                        solrQuery.addSort(field, SolrQuery.ORDER.desc);
                        break;
                    }
                    default: {
                        String message = "Unsupported SortOrder: " + sortOrderValue;
                        this.handleError(message);
                    }
                }
            }
        }
        return solrQuery;
    }

    SolrQuery addFaceting(SolrQuery solrQuery) {
        List facetByConfig = this._params.getFacetByConfig();
        if (facetByConfig != null && !facetByConfig.isEmpty()) {
            for (AnyMap facet : facetByConfig) {
                String field;
                String facetField = null;
                if (facet.containsKey((Object)"attribute")) {
                    facetField = facet.getStringValue("attribute");
                    this.addFacetSettings(solrQuery, facet, facetField);
                    this.addFacetFilters(facet, facetField);
                    field = this.addFacetLocalParams(facet, facetField);
                    solrQuery.addFacetField(new String[]{field});
                    continue;
                }
                if (facet.containsKey((Object)"query")) {
                    facetField = facet.getStringValue("query");
                    this.addFacetFilters(facet, facetField);
                    this.addFacetQueries(solrQuery, facet);
                    continue;
                }
                if (facet.containsKey((Object)"range")) {
                    Value gap;
                    Value end;
                    facetField = facet.getStringValue("range");
                    this.addFacetSettings(solrQuery, facet, facetField);
                    this.addFacetFilters(facet, facetField);
                    String range = this.addFacetLocalParams(facet, facetField);
                    Value start = facet.getValue("start");
                    if (start == null) {
                        this.handleError("start must not be null.");
                    }
                    if ((end = facet.getValue("end")) == null) {
                        this.handleError("end must not be null.");
                    }
                    if ((gap = facet.getValue("gap")) == null) {
                        this.handleError("gap must not be null.");
                    }
                    if (start.isNumber() && end.isNumber() && gap.isNumber()) {
                        solrQuery.addNumericRangeFacet(range, (Number)start.asDouble(), (Number)end.asDouble(), (Number)gap.asDouble());
                        continue;
                    }
                    if (start.isDateTime() && end.isDateTime() && gap.isString()) {
                        solrQuery.addDateRangeFacet(range, start.asDate(), end.asDate(), gap.asString());
                        continue;
                    }
                    this.handleError("Invalid facet range arguments");
                    continue;
                }
                if (facet.containsKey((Object)"pivot")) {
                    AnySeq pivot;
                    Any any = (Any)facet.get((Object)"pivot");
                    if (!any.isSeq() || (pivot = any.asSeq()).isEmpty()) continue;
                    String[] fields = new String[pivot.size()];
                    int pivotCount = 0;
                    for (String val : pivot.asSeq().asStrings()) {
                        fields[pivotCount] = this.addFacetLocalParams(facet, val);
                        ++pivotCount;
                    }
                    solrQuery.addFacetField(fields);
                    continue;
                }
                if (facet.containsKey((Object)"interval")) {
                    facetField = facet.getStringValue("interval");
                    this.addFacetFilters(facet, facetField);
                    field = this.addFacetLocalParams(facet, facetField);
                    AnySeq set = facet.getSeq("set");
                    String[] intervals = ArrayUtils.EMPTY_STRING_ARRAY;
                    if (set != null) {
                        intervals = set.asStrings().toArray(new String[set.size()]);
                    }
                    solrQuery.addIntervalFacets(field, intervals);
                    continue;
                }
                this.handleError("Unsupported facet type");
            }
        }
        return solrQuery;
    }

    private void addFacetSettings(SolrQuery solrQuery, AnyMap facet, String field) {
        String sortString;
        Long maxcount = facet.getLongValue("maxcount");
        if (maxcount != null) {
            String limitParam = SolrUtils.getPerFieldParameter(field, "facet.limit");
            solrQuery.set(limitParam, new String[]{String.valueOf(maxcount)});
        }
        if (facet.containsKey((Object)"sortby") && (sortString = facet.getMap("sortby").getStringValue("criterion")) != null) {
            SolrConstants.FacetSort sort = SolrConstants.FacetSort.get(sortString);
            String sortParam = SolrUtils.getPerFieldParameter(field, "facet.sort");
            solrQuery.set(sortParam, new String[]{sort.toString()});
        }
    }

    private void addFacetFilters(AnyMap facet, String defaultLabel) {
        AnySeq filters = facet.getSeq("filter");
        if (filters != null) {
            for (Any any : filters) {
                if (!any.isMap()) continue;
                AnyMap filter = any.asMap();
                String filterString = this.parseFilterStrings(filter, defaultLabel);
                String label = StringUtils.defaultIfEmpty((String)filter.getStringValue("group"), (String)defaultLabel);
                boolean multiselect = BooleanUtils.toBoolean((Boolean)facet.getBooleanValue("multiselect"));
                AnyMap localParams = null;
                if (multiselect) {
                    String tag = new StringBuffer("fq").append("_").append(label).toString();
                    localParams = SolrUtils.putLocalParam(filter, "tag", tag, multiselect, SolrUtils.LocalParamsMode.OVERWRITE);
                    SolrUtils.putLocalParam(facet, "ex", tag, true, SolrUtils.LocalParamsMode.ADD);
                }
                this._groupedFilters.get(label).add(filterString, localParams);
            }
        }
    }

    private String addFacetLocalParams(AnyMap facet, String param) {
        AnyMap localParams;
        String name = facet.getStringValue("name");
        if (!StringUtils.isBlank((String)name)) {
            SolrUtils.putLocalParam(facet, "key", name, true);
        }
        if (!MapUtils.isEmpty((Map)(localParams = facet.getMap("localParams")))) {
            return SolrUtils.addLocalParams(param, localParams).toString();
        }
        return param;
    }

    private void addFacetQueries(SolrQuery solrQuery, AnyMap facet) {
        String attribute = facet.getStringValue("query");
        AnySeq expression = facet.getSeq("queries");
        AnyMap localParams = facet.getMap("localParams");
        ArrayList<String> queries = new ArrayList<String>();
        for (Any any : expression) {
            if (!any.isValue()) continue;
            StringBuilder sb = new StringBuilder(attribute);
            sb.append(":");
            sb.append(any.asValue().asString());
            queries.add(sb.toString());
        }
        String originalKey = StringUtils.defaultIfEmpty((String)localParams.getStringValue("key"), (String)attribute);
        ListIterator query = queries.listIterator();
        while (query.hasNext()) {
            int index = query.nextIndex();
            String key = String.valueOf(originalKey) + "_" + index;
            SolrUtils.putLocalParam(facet, "key", key, false, SolrUtils.LocalParamsMode.OVERWRITE);
            String facetQuery = SolrUtils.addLocalParams((String)query.next(), localParams).toString();
            solrQuery.addFacetQuery(facetQuery);
        }
        SolrUtils.putLocalParam(facet, "key", originalKey, false, SolrUtils.LocalParamsMode.OVERWRITE);
    }

    SolrQuery addGrouping(SolrQuery solrQuery) {
        List groupByConfig = this._params.getGroupByConfig();
        if (groupByConfig != null && !groupByConfig.isEmpty()) {
            solrQuery.add("group", new String[]{Boolean.toString(true)});
            for (AnyMap groupBy : groupByConfig) {
                if (groupBy.containsKey((Object)"attribute")) {
                    String field = groupBy.getStringValue("attribute");
                    solrQuery.add("group.field", new String[]{field});
                    continue;
                }
                if (groupBy.containsKey((Object)"func")) {
                    String func = groupBy.getStringValue("func");
                    solrQuery.add("group.func", new String[]{func});
                    continue;
                }
                if (groupBy.containsKey((Object)"query")) {
                    String query = groupBy.getStringValue("query");
                    solrQuery.add("group.query", new String[]{query});
                    continue;
                }
                this.handleError("Invalid group type");
            }
        }
        return solrQuery;
    }

    SolrQuery addFilters(SolrQuery solrQuery) {
        List filterConfig = this._params.getFilterConfig();
        if (filterConfig != null && !filterConfig.isEmpty()) {
            for (AnyMap filter : filterConfig) {
                String attribute = filter.getStringValue("attribute");
                if (StringUtils.isBlank((String)attribute)) {
                    throw new IllegalArgumentException("Filter syntax error: Attribute must not be blank");
                }
                String group = StringUtils.defaultString((String)filter.getStringValue("group"), (String)attribute);
                String filterString = this.parseFilterStrings(filter, attribute);
                AnyMap localParams = filter.getMap("localParams");
                this._groupedFilters.get(group).add(filterString, localParams);
            }
        }
        for (FilterGroup filterGroup : this._groupedFilters.values()) {
            StringBuilder fq = this.resetBuffer();
            SolrUtils.writeLocalParams(fq, filterGroup._localParams);
            String mergedFq = filterGroup.merge(fq);
            solrQuery.addFilterQuery(new String[]{mergedFq});
        }
        return solrQuery;
    }

    /*
     * Exception decompiling
     */
    private String parseFilterStrings(AnyMap filterConfig, String attribute) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[12] lbl85 : CaseStatement: default:\u000a, @NONE, blocks:[12] lbl85 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void appendListFilter(StringBuilder fq, String attribute, AnySeq values, String operator) {
        List filterValues;
        try {
            filterValues = values.asStrings();
        }
        catch (InvalidValueTypeException invalidValueTypeException) {
            throw new InvalidValueTypeException("Filter syntax error: Must be of typ AnySeq and contain only Value elements.");
        }
        for (String val : filterValues) {
            SolrUtils.escapeWS(val);
            fq.append(operator);
            fq.append("(");
            fq.append(attribute);
            fq.append(":");
            fq.append(val);
            fq.append(")");
        }
    }

    private void appendBoundFilter(StringBuilder fq, String attribute, String lower, String upper, boolean exclusive) {
        if (StringUtils.isBlank((String)lower)) {
            throw new IllegalArgumentException("Filter syntax error: Lower must not be blank.");
        }
        if (StringUtils.isBlank((String)upper)) {
            throw new IllegalArgumentException("Filter syntax error: Upper must not be blank.");
        }
        lower = this.excludeNonWildcardBound(fq, attribute, lower, exclusive);
        upper = this.excludeNonWildcardBound(fq, attribute, upper, exclusive);
        fq.append("+");
        fq.append("(");
        fq.append(attribute);
        fq.append(":");
        fq.append("[");
        fq.append(lower);
        fq.append(" ");
        fq.append("TO");
        fq.append(" ");
        fq.append(upper);
        fq.append("]");
        fq.append(")");
    }

    private String excludeNonWildcardBound(StringBuilder fq, String attribute, String bound, boolean exclusive) {
        if (!bound.equals("*")) {
            bound = SolrUtils.escapeWS(bound);
            if (exclusive) {
                fq.append("-");
                fq.append("(");
                fq.append(attribute);
                fq.append(":");
                fq.append(bound);
                fq.append(")");
            }
        }
        return bound;
    }

    private void handleError(String message) {
    }

    private StringBuilder resetBuffer() {
        this._buffer.setLength(0);
        return this._buffer;
    }

    class FilterGroup {
        final List<String> _filterStrings = new ArrayList<String>();
        final AnyMap _localParams = DataFactory.DEFAULT.createAnyMap();

        FilterGroup() {
        }

        void add(String filterString, AnyMap localParams) {
            this._filterStrings.add(filterString);
            if (localParams != null) {
                this._localParams.putAll((Map)localParams);
            }
        }

        String merge(StringBuilder fq) {
            if (this._filterStrings.isEmpty()) {
                return "";
            }
            if (this._filterStrings.size() == 1) {
                fq.append(this._filterStrings.get(0));
                return fq.toString();
            }
            for (String filterString : this._filterStrings) {
                fq.append("+");
                fq.append("(");
                fq.append(filterString);
                fq.append(")");
            }
            return fq.toString();
        }
    }
}

