/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.server;

import java.util.Collection;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.core.CoreContainer;
import org.eclipse.smila.solr.SolrConfig;
import org.eclipse.smila.solr.server.SolrServers;

public class EmbeddedServers
extends SolrServers {
    private final CoreContainer _coreContainer;

    public EmbeddedServers(SolrConfig config) {
        super(config);
        String solrHome = this.getConfig().getEmbeddedSolrServerSolrHome();
        this._coreContainer = new CoreContainer(solrHome);
        this._coreContainer.load();
    }

    @Override
    protected SolrServer createServer(String index) throws Exception {
        EmbeddedSolrServer server = new EmbeddedSolrServer(this._coreContainer, index);
        server.ping();
        return server;
    }

    @Override
    protected SolrServer createServer() throws Exception {
        Collection coreNames = this._coreContainer.getCoreNames();
        if (coreNames.isEmpty()) {
            String message = String.format("No core available for admin operations. Update solr.home: s%", this._coreContainer.getSolrHome());
            throw new SolrServerException(message);
        }
        return this.createServer((String)coreNames.iterator().next());
    }

    @Override
    public void shutdown() {
        if (this._coreContainer != null) {
            this._coreContainer.shutdown();
        }
        super.shutdown();
    }
}

