/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.definitions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.smila.common.definitions.AccessAny;
import org.eclipse.smila.common.definitions.DefinitionBase;
import org.eclipse.smila.common.exceptions.InvalidDefinitionException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.jobmanager.definitions.JobRunMode;

public class JobDefinition
extends DefinitionBase {
    public static final String KEY_JOBS = "jobs";
    public static final String KEY_MODES = "modes";
    public static final String KEY_PARAMETERS = "parameters";
    public static final String KEY_WORKFLOW = "workflow";
    public static final String KEY_TASK_CONTROL = "taskControl";
    public static final String KEY_TASK_CONTROL_WORKERS = "workers";
    public static final String KEY_TASK_CONTROL_DELAY = "delay";
    private final List<JobRunMode> _modes;
    private final AnyMap _parameters;
    private final String _workflow;
    private final List<String> _taskDelayWorkers = new ArrayList<String>();
    private long _taskDelay;

    public JobDefinition(AnyMap job) throws InvalidDefinitionException {
        super(job);
        this._workflow = AccessAny.getStringRequired((AnyMap)this._definitionMap, (String)KEY_WORKFLOW);
        Any parametersAny = (Any)this._definitionMap.get((Object)KEY_PARAMETERS);
        if (parametersAny == null) {
            this._parameters = null;
        } else {
            if (!parametersAny.isMap()) {
                throw new InvalidDefinitionException("Error reading jobs record object. Field parameter is not of type MAP.");
            }
            try {
                this._parameters = (AnyMap)parametersAny;
            }
            catch (Exception e) {
                throw new InvalidDefinitionException("Error reading parameters for jobs record object.", (Throwable)e);
            }
        }
        AnySeq modesAny = this._definitionMap.getSeq(KEY_MODES);
        try {
            this._modes = JobRunMode.parseModes(modesAny);
        }
        catch (InvalidDefinitionException ex) {
            throw new InvalidDefinitionException("Job '" + this._name + "': " + ex.getMessage());
        }
        AnyMap taskControl = this._definitionMap.getMap(KEY_TASK_CONTROL);
        if (taskControl != null) {
            this.parseTaskControl(taskControl);
        }
    }

    private void parseTaskControl(AnyMap taskControl) throws InvalidDefinitionException {
        try {
            AnySeq workers = taskControl.getSeq(KEY_TASK_CONTROL_WORKERS);
            if (workers == null || workers.isEmpty()) {
                throw new InvalidDefinitionException("Job '" + this._name + "': task control section does not contain worker names.");
            }
            Long delayValue = taskControl.getLongValue(KEY_TASK_CONTROL_DELAY);
            if (delayValue == null) {
                throw new InvalidDefinitionException("Job '" + this._name + "': task control section does not contain value for delay.");
            }
            if (delayValue < 0L) {
                throw new InvalidDefinitionException("Job '" + this._name + "': task control delay must not be negative.");
            }
            for (Any any : workers) {
                this._taskDelayWorkers.add(any.asValue().asString());
            }
            this._taskDelay = delayValue;
        }
        catch (InvalidValueTypeException ex) {
            throw new InvalidDefinitionException("Job '" + this._name + "' contains invalid values in task control section: " + ex.getMessage());
        }
    }

    public static JobDefinition parseJob(AnyMap jobAny) throws InvalidDefinitionException {
        JobDefinition job = null;
        try {
            job = new JobDefinition(jobAny);
        }
        catch (InvalidDefinitionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidDefinitionException("Invalid any structure", (Throwable)ex);
        }
        return job;
    }

    public List<JobRunMode> getJobRunModes() {
        return AccessAny.copyCollection(this._modes);
    }

    public JobRunMode getDefaultJobRunMode() {
        if (this._modes == null) {
            return null;
        }
        return this.getJobRunModes().get(0);
    }

    public AnyMap getParameters() {
        return AccessAny.cloneAnyMap((AnyMap)this._parameters);
    }

    public String getWorkflow() {
        return this._workflow;
    }

    public List<String> getTaskDelayWorkers() {
        return AccessAny.copyCollection(this._taskDelayWorkers);
    }

    public long getTaskDelay() {
        return this._taskDelay;
    }

    public AnyMap toAny(boolean includingAdditionalAttributes) {
        try {
            AnyMap jobAny = super.toAny(includingAdditionalAttributes);
            if (!includingAdditionalAttributes) {
                jobAny.put(KEY_WORKFLOW, this._workflow);
                if (this._modes != null) {
                    jobAny.put(KEY_MODES, (Any)JobRunMode.toAny(this._modes));
                }
                if (this._parameters != null) {
                    jobAny.put(KEY_PARAMETERS, (Any)this._parameters);
                }
                if (!this._taskDelayWorkers.isEmpty()) {
                    AnySeq workerSeq = jobAny.getMap(KEY_TASK_CONTROL, true).getSeq(KEY_TASK_CONTROL_WORKERS, true);
                    for (String worker : this._taskDelayWorkers) {
                        workerSeq.add(worker);
                    }
                    jobAny.getMap(KEY_TASK_CONTROL).put(KEY_TASK_CONTROL_DELAY, (Number)this._taskDelay);
                }
            }
            return jobAny;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to create Any object for job " + this._name, ex);
        }
    }
}

