/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import org.eclipse.smila.common.exceptions.InvalidDefinitionException;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.jobmanager.JobRunDataProvider;
import org.eclipse.smila.jobmanager.JobRunEngine;
import org.eclipse.smila.jobmanager.JobTaskProcessor;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;
import org.eclipse.smila.jobmanager.exceptions.InvalidConfigException;
import org.eclipse.smila.jobmanager.exceptions.PersistenceException;
import org.eclipse.smila.utils.http.NotFoundHTTPResult;

public abstract class AJobManagerHandler
extends JsonRequestHandler {
    private JobRunDataProvider _jobRunDataProvider;
    private JobRunEngine _jobRunEngine;
    private JobTaskProcessor _jobTaskProcessor;
    private DefinitionPersistence _defPersistence;

    public JobRunDataProvider getJobRunDataProvider() {
        return this._jobRunDataProvider;
    }

    public JobRunEngine getJobRunEngine() {
        return this._jobRunEngine;
    }

    public JobTaskProcessor getJobTaskProcessor() {
        return this._jobTaskProcessor;
    }

    public DefinitionPersistence getDefinitionPersistence() {
        return this._defPersistence;
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return this.isGetRequest(method);
    }

    protected boolean isGetRequest(String method) {
        return "GET".equals(method);
    }

    protected boolean isPostRequest(String method) {
        return "POST".equals(method);
    }

    protected boolean isDeleteRequest(String method) {
        return "DELETE".equals(method);
    }

    protected boolean isGetOrDeleteRequest(String method) {
        return this.isGetRequest(method) || this.isDeleteRequest(method);
    }

    protected boolean isGetOrPostRequest(String method) {
        return this.isGetRequest(method) || this.isPostRequest(method);
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof IllegalArgumentException || ex instanceof InvalidConfigException || ex instanceof InvalidDefinitionException || ex instanceof InvalidValueTypeException) {
            return 400;
        }
        if (ex instanceof NotFoundHTTPResult) {
            return 404;
        }
        if (ex instanceof PersistenceException) {
            return 500;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    public void setJobRunDataProvider(JobRunDataProvider jobRunDataProvider) {
        this._jobRunDataProvider = jobRunDataProvider;
    }

    public void unsetJobRunDataProvider(JobRunDataProvider jobRunDataProvider) {
        if (this._jobRunDataProvider == jobRunDataProvider) {
            this._jobRunDataProvider = null;
        }
    }

    public void setJobRunEngine(JobRunEngine jobRunEngine) {
        this._jobRunEngine = jobRunEngine;
    }

    public void unsetJobRunEngine(JobRunEngine jobRunEngine) {
        if (this._jobRunEngine == jobRunEngine) {
            this._jobRunEngine = null;
        }
    }

    public void setJobTaskProcessor(JobTaskProcessor jobTaskProcessor) {
        this._jobTaskProcessor = jobTaskProcessor;
    }

    public void unsetJobTaskProcessor(JobTaskProcessor jobTaskProcessor) {
        if (this._jobTaskProcessor == jobTaskProcessor) {
            this._jobTaskProcessor = null;
        }
    }

    public void setDefinitionPersistence(DefinitionPersistence defPersistence) {
        this._defPersistence = defPersistence;
    }

    public void unsetDefinitionPersistence(DefinitionPersistence defPersistence) {
        if (this._defPersistence == defPersistence) {
            this._defPersistence = null;
        }
    }
}

