/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.util.List;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.jobmanager.exceptions.IllegalJobStateException;
import org.eclipse.smila.jobmanager.exceptions.JobDependencyException;
import org.eclipse.smila.jobmanager.httphandler.AJobManagerHandler;

public class JobRunControlHandler
extends AJobManagerHandler {
    public static final String CMD_FINISH = "finish";
    public static final String CMD_CANCEL = "cancel";
    private static final int URIPARTS_COUNT = 3;

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() == 3) {
            String jobName = (String)uriParts.get(0);
            String jobId = (String)uriParts.get(1);
            String command = (String)uriParts.get(2);
            if (CMD_FINISH.equals(command)) {
                this.getJobRunEngine().finishJob(jobName, jobId);
            } else if (CMD_CANCEL.equals(command)) {
                this.getJobRunEngine().cancelJob(jobName, jobId);
            } else {
                throw new IllegalArgumentException("Invalid request URI, operation '" + command + "' not supported for job runs");
            }
            return null;
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'");
    }

    @Override
    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof IllegalJobStateException) {
            return ((IllegalJobStateException)((Object)ex)).isJobRunGone() ? 410 : 400;
        }
        if (ex instanceof JobDependencyException) {
            return 400;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    protected int getSuccessStatus(String method, String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        String command = (String)uriParts.get(2);
        return CMD_FINISH.equals(command) ? 202 : 200;
    }

    @Override
    protected boolean isValidMethod(String method, String requestUri) {
        return this.isPostRequest(method);
    }
}

