/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.client.impl;

import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.AuthCache;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.eclipse.smila.http.client.impl.base.HttpRequestExecutor;

public class DefaultHttpRequestExecutor
implements HttpRequestExecutor {
    private final String _hostAndPort;
    private final AuthCache _authCache = new BasicAuthCache();

    public DefaultHttpRequestExecutor(String hostAndPort) {
        this._hostAndPort = hostAndPort.toLowerCase().startsWith("http://") ? hostAndPort : "http://" + hostAndPort;
    }

    @Override
    public String getHostAndPort() {
        return this._hostAndPort;
    }

    @Override
    public HttpResponse execute(HttpClient client, HttpUriRequest request) throws IOException {
        HttpContext context = this.createHttpContext();
        return client.execute(request, context);
    }

    private final HttpContext createHttpContext() {
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.auth.auth-cache", (Object)this._authCache);
        return context;
    }
}

