/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.client.impl;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.ipc.IpcAnyReader;
import org.eclipse.smila.http.client.RestException;
import org.eclipse.smila.http.client.impl.base.BulkResponseImpl;
import org.eclipse.smila.http.client.impl.base.HttpResultHandler;

public class DefaultHttpResultHandler
implements HttpResultHandler {
    private final IpcAnyReader _jsonReader = new IpcAnyReader();
    private final Log _log = LogFactory.getLog(this.getClass());

    @Override
    public InputStream processHttpResponse(HttpUriRequest request, HttpResponse response) throws IOException, RestException {
        InputStream content = null;
        boolean requestCompleted = false;
        if (response != null) {
            try {
                int httpStatus = response.getStatusLine().getStatusCode();
                if (httpStatus == 204) {
                    this._log.info((Object)"Request succeeded with no-content response.");
                    return null;
                }
                String responseMimeType = this.getResponseMimeType(response);
                if ("application/json".equalsIgnoreCase(responseMimeType)) {
                    if (response.getEntity() != null) {
                        content = response.getEntity().getContent();
                    }
                    if (httpStatus >= 400) {
                        throw this.newRestException(httpStatus, response, content);
                    }
                } else {
                    this.processNonJsonResponse(response, httpStatus);
                }
                requestCompleted = true;
            }
            finally {
                if (!requestCompleted) {
                    request.abort();
                }
            }
        }
        return content;
    }

    private void processNonJsonResponse(HttpResponse response, int httpStatus) throws IOException, RestException {
        HttpEntity entity = response.getEntity();
        String responseBody = this.getResponseBodyAsString(entity);
        if (httpStatus >= 400) {
            if (this._log.isErrorEnabled()) {
                if (responseBody != null) {
                    this._log.info((Object)("Request failed with non-JSON response: " + responseBody));
                } else {
                    this._log.info((Object)"Request failed with empty non-JSON response");
                }
            }
            throw this.newRestException(httpStatus, response, null);
        }
        if (this._log.isInfoEnabled()) {
            if (responseBody != null) {
                this._log.info((Object)("Request succeeded with non-JSON response: " + responseBody));
            } else {
                this._log.info((Object)"Request succeeded with empty non-JSON response");
            }
        }
    }

    private String getResponseBodyAsString(HttpEntity entity) throws IOException {
        if (entity == null) {
            return null;
        }
        String responseBody = EntityUtils.toString((HttpEntity)entity);
        if (entity.getContentLength() == 0L) {
            return null;
        }
        return responseBody;
    }

    private String getResponseMimeType(HttpResponse response) {
        HeaderElement[] elements;
        String responseContentType = null;
        Header contentTypeHeader = response.getFirstHeader("Content-Type");
        if (contentTypeHeader != null && (elements = contentTypeHeader.getElements()) != null && elements.length > 0) {
            responseContentType = elements[0].getName();
        }
        return responseContentType;
    }

    private RestException newRestException(int statusCode, HttpResponse response, InputStream content) throws IOException {
        if (content != null) {
            Any errorObject = null;
            try {
                errorObject = this.handleJsonResult(content);
            }
            catch (Exception ex) {
                this._log.error((Object)"Failed to parse an error result", (Throwable)ex);
            }
            if (errorObject != null && errorObject.isMap()) {
                return new RestException(statusCode, errorObject.asMap());
            }
        }
        return new RestException(statusCode, "Error Code: " + statusCode + " " + response.getStatusLine().getReasonPhrase() + ", See log for details.");
    }

    @Override
    public Any handleJsonResult(InputStream content) throws IOException {
        if (content != null) {
            try {
                Any any = this._jsonReader.readJsonStream(content);
                return any;
            }
            catch (EOFException eOFException) {
            }
            finally {
                IOUtils.closeQuietly((InputStream)content);
            }
        }
        return null;
    }

    @Override
    public BulkResponseImpl handleJsonBulkResult(InputStream content) throws IOException {
        boolean isContentConsumed = false;
        if (content == null) {
            content = new ByteArrayInputStream(new byte[0]);
        }
        try {
            BulkResponseImpl bulk = new BulkResponseImpl(content);
            isContentConsumed = true;
            BulkResponseImpl bulkResponseImpl = bulk;
            return bulkResponseImpl;
        }
        finally {
            if (!isContentConsumed) {
                IOUtils.closeQuietly((InputStream)content);
            }
        }
    }
}

