/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.util.ResultCollector;
import org.eclipse.smila.utils.codec.EncodingTools;

public class CodecPipelet
implements Pipelet {
    public static final String KEY_NAME = "name";
    public static final String KEY_CONTENT = "content";
    public static final String PROP_ATTRIBUTE_NAME = "encodedContentAttribute";
    public static final Charset CHARSET = Charset.forName("UTF-8");
    public static final String PROP_CODEC_NAME = "codec";
    public static final String PROP_ENCODE = "encode";
    public static final String PROP_REMOVE_INPUT = "removeInput";
    public static final String DEFAULT_ATTRIBUTE_NAME = "_attachments";
    public static final String ENCODING_BASE64 = "BASE64";
    public static final String DEFAULT_ENCODING = "BASE64";
    public static final Collection<String> SUPPORTED_ENCODINGS = Collections.singletonList("BASE64".toUpperCase(Locale.ENGLISH));
    private AnyMap _config;
    private final Log _log = LogFactory.getLog(this.getClass());

    public void configure(AnyMap configuration) throws ProcessingException {
        this._config = configuration;
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        ParameterAccessor paramAccessor = new ParameterAccessor(blackboard, this._config);
        ResultCollector resultCollector = new ResultCollector(paramAccessor, this._log, false);
        if (recordIds != null) {
            String[] stringArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                try {
                    paramAccessor.setCurrentRecord(id);
                    String attributeName = paramAccessor.getParameter(PROP_ATTRIBUTE_NAME, DEFAULT_ATTRIBUTE_NAME);
                    String encodingName = paramAccessor.getParameter(PROP_CODEC_NAME, "BASE64");
                    boolean removeInput = paramAccessor.getBooleanParameter(PROP_REMOVE_INPUT, Boolean.valueOf(false));
                    boolean encode = paramAccessor.getBooleanParameter(PROP_ENCODE, Boolean.valueOf(false));
                    if (!SUPPORTED_ENCODINGS.contains(encodingName.toUpperCase(Locale.ENGLISH))) {
                        throw new ProcessingException("Encoding " + encodingName + " is not supported.");
                    }
                    if (encode) {
                        Record record = blackboard.getRecord(id);
                        Iterator attachmentNamesIter = record.getAttachmentNames();
                        ArrayList<String> attachmentNames = new ArrayList<String>();
                        while (attachmentNamesIter.hasNext()) {
                            attachmentNames.add((String)attachmentNamesIter.next());
                        }
                        for (String attachmentName : attachmentNames) {
                            AnyMap attachmentEntry = this.encodeAttachment(blackboard, id, encodingName, attachmentName);
                            record.getMetadata().add(attributeName, (Any)attachmentEntry);
                            if (!removeInput) continue;
                            blackboard.removeAttachment(id, attachmentName);
                        }
                    } else {
                        AnyMap metadata = blackboard.getMetadata(id);
                        if (metadata.containsKey((Object)attributeName)) {
                            for (Any attachmentEntry : (Any)metadata.get((Object)attributeName)) {
                                AnyMap entry = attachmentEntry.asMap();
                                this.decodeEntry(blackboard, id, encodingName, entry);
                            }
                            if (removeInput) {
                                metadata.remove((Object)attributeName);
                            }
                        }
                    }
                    blackboard.commitRecord(id);
                    resultCollector.addResult(id);
                }
                catch (Exception ex) {
                    resultCollector.addFailedResult(id, ex);
                }
                ++n2;
            }
        }
        return resultCollector.getResultIds();
    }

    protected AnyMap encodeAttachment(Blackboard blackboard, String id, String encodingName, String attachmentName) throws BlackboardAccessException, IOException {
        String encodingString;
        switch (encodingName.toUpperCase(Locale.ENGLISH)) {
            case "BASE64": {
                encodingString = EncodingTools.toBase64((InputStream)blackboard.getAttachmentAsStream(id, attachmentName));
                break;
            }
            default: {
                encodingString = EncodingTools.toBase64((InputStream)blackboard.getAttachmentAsStream(id, attachmentName));
            }
        }
        AnyMap attachmentEntry = DataFactory.DEFAULT.createAnyMap();
        attachmentEntry.put(KEY_NAME, attachmentName);
        attachmentEntry.put(KEY_CONTENT, encodingString);
        return attachmentEntry;
    }

    protected void decodeEntry(Blackboard blackboard, String id, String encodingName, AnyMap entry) throws BlackboardAccessException {
        Base64InputStream attachmentStream;
        String attachmentName = entry.getStringValue(KEY_NAME);
        ByteArrayInputStream sourceStream = new ByteArrayInputStream(entry.getStringValue(KEY_CONTENT).getBytes(CHARSET));
        switch (encodingName.toUpperCase(Locale.ENGLISH)) {
            case "BASE64": {
                attachmentStream = new Base64InputStream((InputStream)sourceStream, false);
                break;
            }
            default: {
                attachmentStream = new Base64InputStream((InputStream)sourceStream, false);
            }
        }
        blackboard.setAttachmentFromStream(id, attachmentName, (InputStream)attachmentStream);
    }
}

