/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.server.internal;

import java.util.Vector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.eclipse.smila.http.server.HttpHandler;
import org.eclipse.smila.http.server.JettyHandler;
import org.eclipse.smila.http.server.internal.HandlerAdapter;

public class HttpServer
extends AbstractLifeCycle {
    private static final String ITEM_ID_CONTEXTS = "Contexts";
    private static final String ITEM_ID_LOGINSERVICE = "LoginService";
    private final Server _server;
    private final HandlerCollection _contexts;
    private final Vector<ContextHandler> _handlers = new Vector();

    public HttpServer(XmlConfiguration configuration) throws Exception {
        this._server = (Server)configuration.configure();
        Object configuredContexts = configuration.getIdMap().get(ITEM_ID_CONTEXTS);
        this._contexts = configuredContexts != null && configuredContexts instanceof HandlerCollection ? (HandlerCollection)configuredContexts : null;
    }

    protected int getPort() {
        Connector[] conn = this._server.getConnectors();
        if (conn.length > 0) {
            return conn[0].getPort();
        }
        return -1;
    }

    protected int[] getPorts() {
        Connector[] connectors = this._server.getConnectors();
        int[] ports = new int[connectors.length];
        int i = 0;
        while (i < connectors.length) {
            ports[i] = connectors[i].getPort();
            ++i;
        }
        return ports;
    }

    public void addHttpHandler(HttpHandler smilaHandler) {
        this.addHandler((Handler)new HandlerAdapter(smilaHandler), smilaHandler.getRootContextPath());
    }

    public void addJettyHandler(JettyHandler jettyHandler) {
        this.addHandler(jettyHandler.getHandler(), jettyHandler.getRootContextPath());
    }

    public void join() throws InterruptedException {
        this._server.join();
    }

    private void addHandler(Handler handler, String rootContextPath) {
        if (handler instanceof ContextHandler) {
            this._handlers.add((ContextHandler)handler);
        } else {
            ContextHandler ctxHandler = new ContextHandler();
            ctxHandler.setHandler(handler);
            ctxHandler.setContextPath(rootContextPath);
            this._handlers.add(ctxHandler);
        }
    }

    protected void doStart() {
        try {
            this.setHandlersOnServer();
            this._server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setHandlersOnServer() {
        if (this._handlers.size() > 0) {
            if (this._contexts != null) {
                this._contexts.setHandlers(this._handlers.toArray(new Handler[this._handlers.size()]));
            } else {
                ContextHandlerCollection contexts = new ContextHandlerCollection();
                contexts.setHandlers(this._handlers.toArray(new Handler[this._handlers.size()]));
                Handler currentHandler = this._server.getHandler();
                if (currentHandler != null) {
                    HandlerList handlerList = new HandlerList();
                    handlerList.setHandlers(new Handler[]{contexts, currentHandler});
                    this._server.setHandler((Handler)handlerList);
                } else {
                    this._server.setHandler((Handler)contexts);
                }
            }
        }
    }

    protected void doStop() {
        try {
            this._server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

