/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.server.util;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.HttpHandler;
import org.eclipse.smila.http.server.util.CorsUtils;
import org.eclipse.smila.http.server.util.RequestHandler;
import org.osgi.service.component.ComponentContext;

public class RequestDispatcher
implements HttpHandler {
    private static final String TARGET_PREFIX = "(rootContextPath=";
    private final ArrayList<RequestHandler> _requestHandlers = new ArrayList();
    private final Log _log = LogFactory.getLog(this.getClass());
    private String _rootContextPath;
    private int _noOfRegisteredHandlers;

    protected void activate(ComponentContext context) {
        this._rootContextPath = this.getRootContextPath(context);
    }

    @Override
    public String getRootContextPath() {
        return this._rootContextPath;
    }

    public synchronized void addRequestHandler(RequestHandler handler) {
        this._requestHandlers.add(handler);
        ++this._noOfRegisteredHandlers;
        String message = "Context " + handler.getRootContextPath() + ": Registered handler(" + this._noOfRegisteredHandlers + ") " + handler.getClass().getSimpleName() + ", pattern " + handler.getUriPattern();
        this._log.info((Object)message);
    }

    public synchronized void removeRequestHandler(RequestHandler handler) {
        if (this._requestHandlers.contains(handler)) {
            this._requestHandlers.remove(handler);
        }
    }

    @Override
    public void handle(HttpExchange he) throws IOException {
        String requestUri = he.getRequestURI();
        RequestHandler matchingHandler = this.findHandler(requestUri);
        if (matchingHandler == null) {
            throw new HttpException(404, "No RequestHandler registered at rootContext '" + this._rootContextPath + "' to handle uri '" + requestUri + "'");
        }
        try {
            boolean isHandled = CorsUtils.setCorsResponseHandlers(he);
            if (!isHandled) {
                matchingHandler.handle(he);
            }
        }
        catch (RuntimeException ex) {
            throw new HttpException(500, "Error executing request", (Throwable)ex);
        }
    }

    private synchronized RequestHandler findHandler(String requestUri) {
        for (RequestHandler handler : this._requestHandlers) {
            if (!handler.matches(requestUri)) continue;
            return handler;
        }
        return null;
    }

    private String getRootContextPath(ComponentContext context) {
        String rootContextPath = context.getProperties().get("RequestHandlers.target").toString();
        rootContextPath = rootContextPath.substring(TARGET_PREFIX.length(), rootContextPath.length() - 1);
        return rootContextPath;
    }
}

