/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.binarystorage.persistence.efs;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.smila.binarystorage.BinaryStorageException;
import org.eclipse.smila.binarystorage.config.BinaryStorageConfiguration;

public class EFSUtils {
    private static IPath _root = null;
    private static IFileStore _store = null;

    public static void init(BinaryStorageConfiguration binaryStorageConfig) {
        _root = EFSUtils.getCanonicalPath(binaryStorageConfig.getPath());
        _store = EFS.getLocalFileSystem().getStore(_root);
    }

    private static Path getCanonicalPath(String filePath) {
        File file = new File(filePath);
        try {
            return new Path(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            return new Path(file.getAbsolutePath());
        }
    }

    public static void writeInputStreamToFile(String path, InputStream stream) throws BinaryStorageException {
        IFileStore record = EFS.getLocalFileSystem().getStore(_root.append((IPath)new Path(path)));
        OutputStream output = null;
        try {
            try {
                output = record.openOutputStream(0, null);
                IOUtils.copy((InputStream)stream, (OutputStream)output);
            }
            catch (CoreException exception) {
                throw new BinaryStorageException((Throwable)exception, "Could not write binary record to :" + path);
            }
            catch (IOException exception) {
                throw new BinaryStorageException((Throwable)exception, "IO stream exception. Could not write binary record to :" + path);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(output);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)output);
    }

    public static void writeByteArrayToFile(String path, byte[] data) throws BinaryStorageException {
        IFileStore store = EFSUtils.mkdirForFileRecord(path);
        BufferedOutputStream output = null;
        try {
            try {
                output = new BufferedOutputStream(store.openOutputStream(0, null));
                output.write(data);
                output.flush();
            }
            catch (CoreException exception) {
                throw new BinaryStorageException((Throwable)exception, "Could not write binary record to :" + path);
            }
            catch (IOException exception) {
                throw new BinaryStorageException((Throwable)exception, "IO stream exception. Could not write binary record to :" + path);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(output);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)output);
    }

    private static IFileStore mkdirForFileRecord(String path) throws BinaryStorageException {
        IFileStore record = EFS.getLocalFileSystem().getStore(_root.append((IPath)new Path(path)));
        try {
            if (!EFSUtils.isRecorParentRoot(record)) {
                record.getParent().mkdir(0, null);
            }
            return record;
        }
        catch (CoreException exception) {
            throw new BinaryStorageException((Throwable)exception, "Could not write binary record to :" + path);
        }
    }

    private static boolean isRecorParentRoot(IFileStore record) {
        return record.getParent().equals(_store);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readFileToByteArray(String path) throws BinaryStorageException {
        byte[] byArray;
        InputStream input = null;
        try {
            IFileStore file = EFS.getLocalFileSystem().getStore(_root.append((IPath)new Path(path)));
            input = file.openInputStream(0, null);
            byArray = IOUtils.toByteArray((InputStream)input);
        }
        catch (CoreException exception) {
            try {
                throw new BinaryStorageException((Throwable)exception, "Could not read binary record from :" + path);
                catch (IOException ioe) {
                    throw new BinaryStorageException((Throwable)ioe, "IO stream sxception. Could not read binary record from :" + path);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        return byArray;
    }

    public static InputStream readFileToInputStream(String path) throws BinaryStorageException {
        IFileStore record = EFS.getLocalFileSystem().getStore(_root.append((IPath)new Path(path)));
        try {
            return record.openInputStream(0, null);
        }
        catch (CoreException exception) {
            throw new BinaryStorageException((Throwable)exception, "Could not read binary record from :" + path);
        }
    }

    public static void deleteFile(String path) throws BinaryStorageException {
        IFileStore file = EFS.getLocalFileSystem().getStore(_root.append((IPath)new Path(path)));
        if (file.fetchInfo().exists()) {
            try {
                file.delete(0, null);
            }
            catch (CoreException exception) {
                throw new BinaryStorageException((Throwable)exception, "Could not delte binary record from :" + path);
            }
        }
    }

    public static long fetchSize(String path) throws BinaryStorageException {
        IFileStore file = EFS.getLocalFileSystem().getStore(_root.append((IPath)new Path(path)));
        IFileInfo info = file.fetchInfo();
        if (info.exists()) {
            return info.getLength();
        }
        throw new BinaryStorageException("file does not exist: " + path);
    }
}

