/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.state.objectstore;

import java.util.Collection;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.importing.DeltaException;
import org.eclipse.smila.importing.VisitedLinksException;
import org.eclipse.smila.importing.VisitedLinksService;
import org.eclipse.smila.importing.state.objectstore.ObjectStoreStateService;
import org.eclipse.smila.importing.state.objectstore.StateException;
import org.eclipse.smila.importing.state.objectstore.StateStoreConfiguration;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.osgi.service.component.ComponentContext;

public class ObjectStoreVisitedLinksService
implements VisitedLinksService {
    public static final String BUNDLE_ID = "org.eclipse.smila.importing.state.objectstore";
    public static final String STORENAME = "visitedlinks";
    private final Log _log = LogFactory.getLog(this.getClass());
    private ObjectStoreStateService _stateService;
    private ObjectStoreService _objectStore;

    protected void activate(ComponentContext context) {
        Properties props;
        try {
            props = ConfigUtils.getConfigProperties((String)BUNDLE_ID, (String)"visitedlinksstore.properties");
        }
        catch (Exception exception) {
            this._log.info((Object)"No configuration org.eclipse.smila.importing.state.objectstore/ found, using default settings.");
            props = new Properties();
        }
        StateStoreConfiguration configuration = new StateStoreConfiguration(props);
        this._stateService = new ObjectStoreStateService(STORENAME, configuration, this._objectStore);
    }

    protected void deactivate(ComponentContext context) {
        this._stateService = null;
    }

    public boolean checkAndMarkVisited(String sourceId, String url, String jobRunId, String inputBulkId) throws VisitedLinksException {
        block4: {
            AnyMap entry;
            block5: {
                try {
                    entry = this._stateService.getEntry(sourceId, url, null);
                    if (entry == null) break block4;
                    String entryJobRunId = entry.getStringValue("jobRunId");
                    if (!jobRunId.equals(entryJobRunId)) break block5;
                    String entryInputBulkId = entry.getStringValue("descriptor");
                    return !inputBulkId.equals(entryInputBulkId);
                }
                catch (StateException ex) {
                    throw new VisitedLinksException("Error checking state for url '" + url + "'", (Throwable)((Object)ex));
                }
            }
            entry.put("jobRunId", jobRunId);
            entry.put("descriptor", inputBulkId);
            this._stateService.writeEntry(entry);
            return false;
        }
        this.markAsVisited(sourceId, url, jobRunId, inputBulkId);
        return false;
    }

    public boolean isVisited(String sourceId, String url, String jobRunId) throws VisitedLinksException {
        try {
            String entryJobRunId;
            AnyMap entry = this._stateService.getEntry(sourceId, url, null);
            return entry != null && jobRunId.equals(entryJobRunId = entry.getStringValue("jobRunId"));
        }
        catch (StateException ex) {
            throw new VisitedLinksException("Error checking state for url '" + url + "'", (Throwable)((Object)ex));
        }
    }

    public void markAsVisited(String sourceId, String url, String jobRunId, String inputBulkId) throws VisitedLinksException {
        try {
            this._stateService.mark(sourceId, url, null, jobRunId, inputBulkId);
        }
        catch (StateException ex) {
            throw new VisitedLinksException("Error marking url '" + url + "' as crawled", (Throwable)((Object)ex));
        }
    }

    public void clearSource(String sourceId) throws VisitedLinksException {
        try {
            this._stateService.clearSource(sourceId);
        }
        catch (StateException ex) {
            throw new VisitedLinksException("Error removing all entries for source " + sourceId, (Throwable)((Object)ex));
        }
    }

    public void clearAll() throws VisitedLinksException {
        try {
            this._stateService.clearAll();
        }
        catch (StateException ex) {
            throw new VisitedLinksException("Error clearing all entries of all sources", (Throwable)((Object)ex));
        }
    }

    public Collection<String> getSourceIds() throws VisitedLinksException {
        try {
            return this._stateService.getSourceIds();
        }
        catch (StateException ex) {
            throw new VisitedLinksException("Error determining existing sources.", (Throwable)((Object)ex));
        }
    }

    public long countEntries(String sourceId, boolean countExact) throws DeltaException {
        try {
            return this._stateService.countEntries(sourceId, countExact);
        }
        catch (StateException ex) {
            throw new DeltaException("Error counting entries for source " + sourceId, (Throwable)((Object)ex));
        }
    }

    public void setObjectStore(ObjectStoreService objectStore) {
        this._objectStore = objectStore;
    }

    public void unsetObjectStore(ObjectStoreService objectStore) {
        if (this._objectStore == objectStore) {
            this._objectStore = null;
        }
    }
}

