/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.httphandler;

import java.util.List;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.processing.PipeletTracker;
import org.eclipse.smila.utils.http.NotFoundHTTPResult;

public class PipeletHandler
extends JsonRequestHandler {
    public static final String EXCEPTION_MESSAGE = "There is no description for the given pipelet";
    private PipeletTracker _pipeletTracker;

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method);
    }

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        String pipeletClassName = this.getPipeletClassName(requestUri);
        AnyMap definitionAny = this._pipeletTracker.getRegisteredPipeletDescriptions().get(pipeletClassName);
        if (definitionAny == null) {
            throw new PipeletDescriptionNotFoundException("There is no description for the given pipelet '" + pipeletClassName + "'.");
        }
        return definitionAny;
    }

    private String getPipeletClassName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern " + this.getUriPattern());
    }

    public void setPipeletTracker(PipeletTracker pipeletTracker) {
        this._pipeletTracker = pipeletTracker;
    }

    public void unsetPipeletTracker(PipeletTracker pipeletTracker) {
        if (this._pipeletTracker == pipeletTracker) {
            this._pipeletTracker = null;
        }
    }

    private static class PipeletDescriptionNotFoundException
    extends Exception
    implements NotFoundHTTPResult {
        private static final long serialVersionUID = 1L;

        public PipeletDescriptionNotFoundException(String message) {
            super(message);
        }
    }
}

