/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskmanager.persistence.zk;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.eclipse.smila.clusterconfig.ClusterConfigService;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.ipc.IpcAnyReader;
import org.eclipse.smila.datamodel.ipc.IpcAnyWriter;
import org.eclipse.smila.taskmanager.BadParameterTaskmanagerException;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskmanager.TaskCounter;
import org.eclipse.smila.taskmanager.TaskList;
import org.eclipse.smila.taskmanager.TaskmanagerException;
import org.eclipse.smila.taskmanager.persistence.TaskStorage;
import org.eclipse.smila.taskmanager.persistence.zk.ZkTaskQueue;
import org.eclipse.smila.zookeeper.ZkConcurrentMap;
import org.eclipse.smila.zookeeper.ZkConnection;
import org.eclipse.smila.zookeeper.ZooKeeperService;
import org.osgi.service.component.ComponentContext;

public class TaskStorageZk
implements TaskStorage {
    public static final String HOST_COUNTER_MAP_ZK_PATH = "/smila/taskmanager/hosts";
    public static final String QUALIFIER_LOCKS_ZK_PATH = "/smila/taskmanager/qualifierlocks";
    public static final String TASK_HANDLER_CONFIGURATION = "/smila/taskmanager/config";
    public static final long TASKSPERHOST_UNLIMITED = -1L;
    private static final long MIN_OPERATION_TIME_TO_LOG = 1000L;
    private ZooKeeperService _zkService;
    private ZkConnection _zk;
    private final IpcAnyWriter _anyWriter = new IpcAnyWriter();
    private final IpcAnyReader _anyReader = new IpcAnyReader();
    private ClusterConfigService _clusterConfigService;
    private final Map<String, ZkTaskQueue> _taskQueues = new ConcurrentHashMap<String, ZkTaskQueue>();
    private String _localHost;
    private final ReadWriteLock _lock = new ReentrantReadWriteLock(true);
    private final Log _log = LogFactory.getLog(this.getClass());
    private long _maxNoOfTasksPerHost = -1L;

    protected void activate(ComponentContext context) {
        try {
            this._lock.writeLock().lock();
            this._log.info((Object)"Activate ZooKeeper taskstorage implementation.");
            this._zk = new ZkConnection(this._zkService);
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    protected void deactivate(ComponentContext context) {
        try {
            this._lock.writeLock().lock();
            this._log.info((Object)"Shutdown ZooKeeper taskstorage implementation.");
            this._zk = null;
            this._taskQueues.clear();
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    public void createTaskQueue(String name) {
        if (!this._taskQueues.containsKey(name)) {
            ZkTaskQueue taskQueue = new ZkTaskQueue(this._zkService, name, this.getLocalHost(), this._maxNoOfTasksPerHost);
            this._taskQueues.put(name, taskQueue);
        }
    }

    public boolean hasTaskQueue(String name) {
        return this._taskQueues.containsKey(name);
    }

    protected Collection<ZkTaskQueue> getTaskQueues() {
        return Collections.unmodifiableCollection(this._taskQueues.values());
    }

    public long getMaxNoOfTasksPerHost() {
        return this._maxNoOfTasksPerHost;
    }

    public void setMaxNoOfTasksPerHost(long maxTasks) {
        this._maxNoOfTasksPerHost = maxTasks;
        for (ZkTaskQueue queue : this.getTaskQueues()) {
            queue.setMaxNoOfTasksPerHost(this._maxNoOfTasksPerHost);
        }
    }

    public Map<String, Integer> getScaleUpCounters() throws TaskmanagerException {
        HashMap<String, Integer> counters = new HashMap<String, Integer>();
        try {
            this._zk.ensurePathExists(HOST_COUNTER_MAP_ZK_PATH);
            ZkConcurrentMap hostsMap = new ZkConcurrentMap(this._zk, HOST_COUNTER_MAP_ZK_PATH);
            for (String host : hostsMap.keySet()) {
                counters.put(host, hostsMap.getInt(host));
            }
        }
        catch (RuntimeException | KeeperException ex) {
            this._log.warn((Object)"Could not read scale-up counters", ex);
        }
        return counters;
    }

    public void storeInProgressTask(Task task) throws TaskmanagerException {
        long start = System.currentTimeMillis();
        this._lock.readLock().lock();
        try {
            try {
                ZkTaskQueue taskQueue = this.getZkTaskQueue(task.getWorkerName(), true);
                taskQueue.putInProgress(task);
            }
            catch (RuntimeException ex) {
                throw new TaskmanagerException("Error storing task to " + task.getWorkerName(), (Throwable)ex);
            }
        }
        finally {
            long t;
            this._lock.readLock().unlock();
            if (this._log.isInfoEnabled() && (t = System.currentTimeMillis() - start) > 1000L) {
                this._log.info((Object)("TaskStorageZk.storeInProgressTask() operation time: " + t + " ms, taskId=" + task.getTaskId()));
            }
        }
    }

    public void storeTask(Task task) throws TaskmanagerException {
        this.storeTask(task.getWorkerName(), task);
    }

    public void storeTask(String workerName, Task task) throws TaskmanagerException {
        long start = System.currentTimeMillis();
        this._lock.readLock().lock();
        try {
            try {
                ZkTaskQueue taskQueue = this.getZkTaskQueue(workerName, true);
                taskQueue.put(task);
            }
            catch (RuntimeException ex) {
                throw new TaskmanagerException("Error storing task in '" + workerName + "' queue", (Throwable)ex);
            }
        }
        finally {
            long t;
            this._lock.readLock().unlock();
            if (this._log.isInfoEnabled() && (t = System.currentTimeMillis() - start) > 1000L) {
                this._log.info((Object)("TaskStorageZk.storeTask() operation time: " + t + " ms, taskId=" + task.getTaskId()));
            }
        }
    }

    public Task getTask(String workerName, String workerHost, Collection<String> qualifiers) throws TaskmanagerException {
        long start = System.currentTimeMillis();
        this._lock.readLock().lock();
        try {
            ZkTaskQueue taskQueue = this.getZkTaskQueue(workerName, true);
            Task task = taskQueue.get(qualifiers, workerHost);
            return task;
        }
        catch (RuntimeException ex) {
            throw new TaskmanagerException("Error getting task for worker " + workerName, (Throwable)ex);
        }
        finally {
            long t;
            this._lock.readLock().unlock();
            if (this._log.isInfoEnabled() && (t = System.currentTimeMillis() - start) > 1000L) {
                this._log.info((Object)("TaskStorageZk.getTask() operation time: " + t + " ms, workerName=" + workerName + ", workerHost=" + workerHost + ", qualifiers=" + qualifiers));
            }
        }
    }

    public Task getInProgressTask(String workerName, String taskId) throws TaskmanagerException {
        long start = System.currentTimeMillis();
        this._lock.readLock().lock();
        try {
            ZkTaskQueue taskQueue = this.getZkTaskQueue(workerName, true);
            Task task = taskQueue.getInProgressTask(taskId);
            return task;
        }
        catch (RuntimeException ex) {
            throw new TaskmanagerException("Error reading task " + taskId + " for worker " + workerName, (Throwable)ex);
        }
        finally {
            long t;
            this._lock.readLock().unlock();
            if (this._log.isInfoEnabled() && (t = System.currentTimeMillis() - start) > 1000L) {
                this._log.info((Object)("TaskStorageZk.getInProgressTask() operation time: " + t + " ms, workerName=" + workerName + ", taskId=" + taskId));
            }
        }
    }

    public void deleteTask(String workerName, String taskId) throws TaskmanagerException {
        long start = System.currentTimeMillis();
        this._lock.readLock().lock();
        try {
            try {
                ZkTaskQueue taskQueue = this.getZkTaskQueue(workerName, true);
                taskQueue.delete(taskId);
            }
            catch (RuntimeException ex) {
                throw new TaskmanagerException("Error deleting task " + taskId + " for worker " + workerName, (Throwable)ex);
            }
        }
        finally {
            long t;
            this._lock.readLock().unlock();
            if (this._log.isInfoEnabled() && (t = System.currentTimeMillis() - start) > 1000L) {
                this._log.info((Object)("TaskStorageZk.deleteTask() operation time: " + t + " ms, workerName=" + workerName + ", taskId=" + taskId));
            }
        }
    }

    public void keepAlive(String workerName, String taskId) throws TaskmanagerException {
        long start = System.currentTimeMillis();
        this._lock.readLock().lock();
        try {
            try {
                ZkTaskQueue taskQueue = this.getZkTaskQueue(workerName, true);
                taskQueue.keepAlive(taskId);
            }
            catch (RuntimeException ex) {
                throw new TaskmanagerException("Error deleting task " + taskId + " for worker " + workerName, (Throwable)ex);
            }
        }
        finally {
            long t;
            this._lock.readLock().unlock();
            if (this._log.isInfoEnabled() && (t = System.currentTimeMillis() - start) > 1000L) {
                this._log.info((Object)("TaskStorageZk.keepAlive() operation time: " + t + " ms, workerName=" + workerName + ", taskId=" + taskId));
            }
        }
    }

    public void purge(String workerName) throws TaskmanagerException {
        this._lock.readLock().lock();
        try {
            try {
                ZkTaskQueue taskQueue = this.getZkTaskQueue(workerName, true);
                taskQueue.purge();
            }
            catch (RuntimeException ex) {
                throw new TaskmanagerException("Error purging tasks for worker " + workerName, (Throwable)ex);
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public void lockQualifiers(String workerName, Collection<String> qualifiers) {
        this._lock.readLock().lock();
        try {
            if (workerName != null && qualifiers != null) {
                for (String qualifier : qualifiers) {
                    try {
                        String qualifierLockPath = this.getQualifierLockPath(workerName, qualifier);
                        this._zk.ensurePathExists(qualifierLockPath);
                    }
                    catch (Exception ex) {
                        this._log.info((Object)("Qualifier lock for  " + workerName + " and qualifier " + qualifier + " could not be created."), (Throwable)ex);
                    }
                }
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public boolean isLockedQualifier(String workerName, String qualifier) throws TaskmanagerException {
        if (qualifier == null) {
            return false;
        }
        try {
            String qualifierLockPath = this.getQualifierLockPath(workerName, qualifier);
            return this._zk.exists(qualifierLockPath) != null;
        }
        catch (RuntimeException | KeeperException ex) {
            throw new TaskmanagerException("Failed to determine if qualifier " + qualifier + " for worker " + workerName + " is locked", ex);
        }
    }

    private String getQualifierLockPath(String workerName, String qualifier) {
        try {
            return "/smila/taskmanager/qualifierlocks/" + workerName + "/" + URLEncoder.encode(qualifier, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void checkQualifierLockAge(long timeToLiveMs) {
        try {
            Stat lockPathStat = this._zk.exists(QUALIFIER_LOCKS_ZK_PATH);
            if (lockPathStat != null && lockPathStat.getNumChildren() > 0) {
                List workers = this._zk.getChildrenSorted(QUALIFIER_LOCKS_ZK_PATH);
                for (String worker : workers) {
                    String workerLockPath = "/smila/taskmanager/qualifierlocks/" + worker;
                    List qualifiers = this._zk.getChildrenSorted(workerLockPath);
                    for (String qualifier : qualifiers) {
                        String qualifierLockPath = String.valueOf(workerLockPath) + "/" + qualifier;
                        try {
                            Stat stat = this._zk.exists(qualifierLockPath);
                            if (stat == null) continue;
                            long mtime = stat.getMtime();
                            long now = System.currentTimeMillis();
                            if (now - mtime <= timeToLiveMs) continue;
                            this._zk.deleteNode(qualifierLockPath);
                        }
                        catch (Exception ex) {
                            this._log.info((Object)("Could not remove qualifier lock " + qualifierLockPath + ". Will try again next time."), (Throwable)ex);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            this._log.info((Object)"Failed to get qualifier locks.", (Throwable)ex);
        }
    }

    public Map<String, TaskCounter> getTaskCounters() throws TaskmanagerException {
        try {
            Collection<String> queueNames = this.getQueueNames();
            HashMap<String, TaskCounter> counters = new HashMap<String, TaskCounter>();
            for (String queueName : queueNames) {
                counters.put(queueName, this.getZkTaskQueue(queueName, true).getTaskCounter());
            }
            return counters;
        }
        catch (Exception ex) {
            throw new TaskmanagerException("Error getting task counters", (Throwable)ex);
        }
    }

    public TaskList getTaskList(String workerName, String section, int maxCount) throws TaskmanagerException {
        try {
            ZkTaskQueue taskQueue = this.getZkTaskQueue(workerName, false);
            if (taskQueue == null) {
                throw new BadParameterTaskmanagerException("Worker name " + workerName + " is invalid.", BadParameterTaskmanagerException.Cause.workerName);
            }
            return taskQueue.getTaskList(section, maxCount);
        }
        catch (Exception ex) {
            throw new TaskmanagerException("Error getting task list for " + workerName + "/" + section, (Throwable)ex);
        }
    }

    public Any getTaskInfo(String workerName, String section, String taskName) throws TaskmanagerException {
        try {
            ZkTaskQueue taskQueue = this.getZkTaskQueue(workerName, false);
            if (taskQueue == null) {
                throw new BadParameterTaskmanagerException("Task pipe " + workerName + " is invalid.", BadParameterTaskmanagerException.Cause.workerName);
            }
            return taskQueue.getTaskInfo(section, taskName);
        }
        catch (Exception ex) {
            throw new TaskmanagerException("Error getting task info for " + workerName + "/" + section + "/" + taskName, (Throwable)ex);
        }
    }

    public long getFailSafetyLevel() {
        return this._zkService.getFailSafetyLevel();
    }

    public void clear() throws TaskmanagerException {
        try {
            for (ZkTaskQueue queue : this._taskQueues.values()) {
                queue.purge();
            }
            this._zk.deleteTree(HOST_COUNTER_MAP_ZK_PATH);
        }
        catch (Exception ex) {
            throw new TaskmanagerException("Error clearing task storage", (Throwable)ex);
        }
    }

    public List<Task> filterDuplicates(List<Task> tasksToBeAdded) throws TaskmanagerException {
        ArrayList<Task> result = new ArrayList<Task>();
        HashMap<String, ArrayList<Task>> workerToTasksMap = new HashMap<String, ArrayList<Task>>();
        for (Task task : tasksToBeAdded) {
            String worker = task.getWorkerName();
            ArrayList<Task> workerTaskList = (ArrayList<Task>)workerToTasksMap.get(worker);
            if (workerTaskList == null) {
                workerTaskList = new ArrayList<Task>();
                workerToTasksMap.put(worker, workerTaskList);
            }
            workerTaskList.add(task);
        }
        for (Map.Entry entry : workerToTasksMap.entrySet()) {
            ZkTaskQueue taskQueue = this.getZkTaskQueue((String)entry.getKey(), false);
            List unfilteredTasks = (List)entry.getValue();
            if (taskQueue != null) {
                List<Task> filteredTasks = taskQueue.filterDuplicates(unfilteredTasks);
                result.addAll(filteredTasks);
                continue;
            }
            result.addAll(unfilteredTasks);
        }
        if (tasksToBeAdded.size() != result.size()) {
            this._log.info((Object)("Returning " + result.size() + " filtered tasks for " + tasksToBeAdded.size() + " original tasks"));
        }
        return result;
    }

    public void storeConfiguration(AnyMap config) throws TaskmanagerException {
        try {
            this._zk.ensurePathExists(TASK_HANDLER_CONFIGURATION);
            byte[] message = this._anyWriter.writeBinaryObject((Any)config);
            this._zk.setData(TASK_HANDLER_CONFIGURATION, message);
        }
        catch (Exception ex) {
            throw new TaskmanagerException("Error saving taskmanager configuration", (Throwable)ex);
        }
    }

    public AnyMap readConfiguration() throws TaskmanagerException {
        AnyMap result = DataFactory.DEFAULT.createAnyMap();
        try {
            Stat statResult = this._zk.exists(TASK_HANDLER_CONFIGURATION);
            if (statResult.getDataLength() > 0) {
                byte[] message = this._zk.getData(TASK_HANDLER_CONFIGURATION);
                result = this._anyReader.readBinaryObject(message);
            }
        }
        catch (Exception ex) {
            throw new TaskmanagerException("Error saving taskmanager configuration", (Throwable)ex);
        }
        return result;
    }

    private synchronized ZkTaskQueue getZkTaskQueue(String taskPipe, boolean create) {
        ZkTaskQueue taskQueue = this._taskQueues.get(taskPipe);
        if (taskQueue == null && create) {
            this.createTaskQueue(taskPipe);
            taskQueue = this._taskQueues.get(taskPipe);
        }
        return taskQueue;
    }

    private String getLocalHost() {
        if (this._localHost == null) {
            this._localHost = this._clusterConfigService.getLocalHost();
        }
        return this._localHost;
    }

    private Collection<String> getQueueNames() throws KeeperException {
        this._zk.ensurePathExists("/smila/tasks");
        return this._zk.getChildrenSorted("/smila/tasks");
    }

    public void setZooKeeperService(ZooKeeperService zooKeeperService) {
        this._zkService = zooKeeperService;
    }

    public void unsetZooKeeperService(ZooKeeperService zooKeeperService) {
        if (this._zkService == zooKeeperService) {
            this._zkService = null;
        }
    }

    public void setClusterConfigService(ClusterConfigService ccs) {
        this._clusterConfigService = ccs;
    }

    public void unsetClusterConfigService(ClusterConfigService ccs) {
        if (this._clusterConfigService == ccs) {
            this._clusterConfigService = null;
        }
    }

    public void removeTasks(AnyMap filterMap) throws TaskmanagerException {
        for (Map.Entry<String, ZkTaskQueue> entry : this._taskQueues.entrySet()) {
            ZkTaskQueue queue = entry.getValue();
            queue.removeTasks(filterMap);
        }
    }
}

