/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.compounds.compress;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.common.mimetype.MimeTypeIdentifier;
import org.eclipse.smila.common.mimetype.MimeTypeParseException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.util.AnyUtil;
import org.eclipse.smila.importing.compounds.CompoundExtractor;
import org.eclipse.smila.importing.compounds.CompoundExtractorException;
import org.eclipse.smila.importing.compounds.compress.AttachmentSettingIterator;
import org.eclipse.smila.utils.config.ConfigUtils;

public class CommonsCompressCompoundExtractorService
implements CompoundExtractor {
    protected static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    protected static final String APPLICATION_OCTETSTREAM = "application/octet-stream";
    protected static final String SUFFIX_TAR = ".tar";
    protected static final String SUFFIX_TGZ = ".tgz";
    protected static final String APPLICATION_ZIP = "application/zip";
    protected static final Map<String, String> COMPRESSION_IDENTIFIERS = new HashMap<String, String>();
    protected static final Map<String, String> ARCHIVE_IDENTIFIERS = new HashMap<String, String>();
    protected static final String KEY_TMP_FILE_NAME = "tmpFileName";
    private static final String BUNDLE_ID = "org.eclipse.smila.importing.compounds.compress";
    protected Charset _charset = DEFAULT_CHARSET;
    private final Log _log = LogFactory.getLog(this.getClass());
    private MimeTypeIdentifier _mimeTypeIdentifier;
    private Path _rootTmpDir;

    static {
        COMPRESSION_IDENTIFIERS.put("application/x-bzip", "bzip2");
        COMPRESSION_IDENTIFIERS.put("application/bzip2", "bzip2");
        COMPRESSION_IDENTIFIERS.put("application/x-gtar", "gz");
        COMPRESSION_IDENTIFIERS.put("application/x-gzip", "gz");
        COMPRESSION_IDENTIFIERS.put("application/x-gunzip", "gz");
        COMPRESSION_IDENTIFIERS.put("application/gzip", "gz");
        ARCHIVE_IDENTIFIERS.put(APPLICATION_ZIP, "zip");
        ARCHIVE_IDENTIFIERS.put("application/x-tar", "tar");
        ARCHIVE_IDENTIFIERS.put("application/tar", "tar");
        ARCHIVE_IDENTIFIERS.put("application/us-tar", "tar");
        ARCHIVE_IDENTIFIERS.put("application/cpio", "cpio");
        ARCHIVE_IDENTIFIERS.put("application/x-cpio", "cpio");
        ARCHIVE_IDENTIFIERS.put("application/x-bcpio", "cpio");
        ARCHIVE_IDENTIFIERS.put("application/x-sv4cpio", "cpio");
        ARCHIVE_IDENTIFIERS.put("application/java-archive", "jar");
    }

    protected void activate() {
        String rootTmpDirName;
        Properties props;
        try {
            props = ConfigUtils.getConfigProperties((String)BUNDLE_ID, (String)"extractor.properties");
        }
        catch (Exception exception) {
            this._log.info((Object)"No configuration org.eclipse.smila.importing.compounds.compress/ found, using default settings.");
            props = new Properties();
        }
        if (props.containsKey("zip.encoding")) {
            this._charset = Charset.forName(props.getProperty("zip.encoding"));
        }
        this._rootTmpDir = (rootTmpDirName = props.getProperty("tmp.dir", null)) != null ? Paths.get(rootTmpDirName, new String[0]) : Paths.get(FileUtils.getTempDirectoryPath(), new String[0]).resolve(BUNDLE_ID);
        try {
            FileUtils.deleteDirectory((File)this._rootTmpDir.toFile());
        }
        catch (IOException iOException) {
            this._log.warn((Object)"Could not delete old temporary files from previous invocation");
        }
    }

    protected void deactivate() {
        if (Files.exists(this._rootTmpDir, new LinkOption[0])) {
            try {
                FileUtils.deleteDirectory((File)this._rootTmpDir.toFile());
            }
            catch (IOException e) {
                this._log.warn((Object)"Could not clean up temp extraction directory.", (Throwable)e);
            }
        }
    }

    public boolean canExtract(File file) {
        if (file == null) {
            return false;
        }
        return this.canExtract(file.getName(), null);
    }

    public boolean canExtract(URL url, String mimeType) {
        if (url == null) {
            return false;
        }
        return this.canExtract(url.getFile(), mimeType);
    }

    public boolean canExtract(String fileName, String mimeType) {
        String detectedMimeType = this.determineMimeType(fileName, mimeType);
        return this.isCompressedFile(detectedMimeType) || this.isArchive(detectedMimeType);
    }

    public Iterator<Record> extract(InputStream compoundInputStream, String fileName, String contentAttachmentName) throws CompoundExtractorException {
        return this.extract(compoundInputStream, fileName, null, contentAttachmentName);
    }

    public Iterator<Record> extract(InputStream compoundInputStream, String fileName, String mimeType, String contentAttachmentName) throws CompoundExtractorException {
        List<Record> records;
        String extractedMimeType = this.determineMimeType(fileName, mimeType);
        if (!this.canExtract((String)null, extractedMimeType)) {
            return new ArrayList().iterator();
        }
        Path tmpDir = this._rootTmpDir.resolve(UUID.randomUUID().toString());
        Record newRecord = DataFactory.DEFAULT.createRecord(fileName);
        newRecord.getMetadata().put("fileName", fileName);
        newRecord.getMetadata().put("isRootCompound", Boolean.valueOf(true));
        try {
            records = this.extractCompoundStream(compoundInputStream, newRecord, fileName, extractedMimeType, tmpDir, new ArrayList<String>());
        }
        finally {
            IOUtils.closeQuietly((InputStream)compoundInputStream);
        }
        return new AttachmentSettingIterator(records, contentAttachmentName, tmpDir);
    }

    private boolean isArchive(String detectedMimeType) {
        return ARCHIVE_IDENTIFIERS.containsKey(detectedMimeType);
    }

    private boolean isCompressedFile(String detectedMimeType) {
        return COMPRESSION_IDENTIFIERS.containsKey(detectedMimeType);
    }

    private String determineMimeType(String fileName, String mimeType) {
        if (fileName != null && (mimeType == null || mimeType.isEmpty() || APPLICATION_OCTETSTREAM.equalsIgnoreCase(mimeType))) {
            try {
                int indexOfPeriod = fileName.lastIndexOf(46);
                if (indexOfPeriod >= 0 && fileName.length() > indexOfPeriod) {
                    return this._mimeTypeIdentifier.identify(fileName.substring(indexOfPeriod + 1));
                }
                return this._mimeTypeIdentifier.identify(fileName);
            }
            catch (MimeTypeParseException mimeTypeParseException) {}
        }
        return mimeType;
    }

    private List<Record> extractCompoundStream(InputStream inputStream, Record record, String fileName, String mimeType, Path tmpDir, List<String> compoundList) throws CompoundExtractorException {
        ArrayList<Record> records = new ArrayList<Record>();
        records.add(record);
        ArrayList<String> newCompoundList = new ArrayList<String>(compoundList);
        if (this.isArchive(mimeType)) {
            record.getMetadata().put("isCompound", Boolean.valueOf(true));
            newCompoundList.add(fileName);
            try {
                if (APPLICATION_ZIP.equalsIgnoreCase(mimeType)) {
                    ZipInputStream archiveInputStream = new ZipInputStream(inputStream, this._charset);
                    ZipEntry entry = archiveInputStream.getNextEntry();
                    while (entry != null) {
                        if (!entry.isDirectory()) {
                            String id = this.computeId(newCompoundList, entry.getName());
                            Record entryRecord = record.getFactory().createRecord(id);
                            entryRecord.getMetadata().put("fileName", entry.getName());
                            entryRecord.getMetadata().put("size", (Number)entry.getSize());
                            long lastModified = entry.getTime();
                            if (lastModified != -1L) {
                                entryRecord.getMetadata().put("time", (Any)record.getFactory().createDateTimeValue(new Date(lastModified)));
                            }
                            entryRecord.getMetadata().put("compounds", AnyUtil.objectToAny(newCompoundList));
                            records.addAll(this.extractCompoundStream(new BufferedInputStream(archiveInputStream), entryRecord, entry.getName(), this.determineMimeType(entry.getName(), null), tmpDir, newCompoundList));
                        }
                        archiveInputStream.closeEntry();
                        entry = archiveInputStream.getNextEntry();
                    }
                } else {
                    Object archiveInputStream = APPLICATION_ZIP.equalsIgnoreCase(mimeType) ? new ZipArchiveInputStream(inputStream, this._charset.name(), true, true) : new ArchiveStreamFactory().createArchiveInputStream(ARCHIVE_IDENTIFIERS.get(mimeType), inputStream);
                    ArchiveEntry entry = archiveInputStream.getNextEntry();
                    while (entry != null) {
                        if (!entry.isDirectory()) {
                            String id = this.computeId(newCompoundList, entry.getName());
                            Record entryRecord = record.getFactory().createRecord(id);
                            entryRecord.getMetadata().put("fileName", entry.getName());
                            entryRecord.getMetadata().put("size", (Number)entry.getSize());
                            Date lastModified = entry.getLastModifiedDate();
                            if (lastModified != null && lastModified.getTime() != -1L) {
                                entryRecord.getMetadata().put("time", (Any)record.getFactory().createDateTimeValue(lastModified));
                            }
                            entryRecord.getMetadata().put("compounds", AnyUtil.objectToAny(newCompoundList));
                            records.addAll(this.extractCompoundStream((InputStream)archiveInputStream, entryRecord, entry.getName(), this.determineMimeType(entry.getName(), null), tmpDir, newCompoundList));
                        }
                        entry = archiveInputStream.getNextEntry();
                    }
                }
            }
            catch (IOException e) {
                this._log.warn((Object)("Cannot extract archive '" + fileName + "'."), (Throwable)e);
            }
            catch (ArchiveException e) {
                this._log.warn((Object)("Cannot extract archive '" + fileName + "'."), (Throwable)e);
            }
        } else if (this.isCompressedFile(mimeType)) {
            record.getMetadata().put("isCompound", Boolean.valueOf(true));
            newCompoundList.add(fileName);
            try {
                String suffix;
                String newFileName;
                CompressorInputStream compressorInputStream = new CompressorStreamFactory().createCompressorInputStream(COMPRESSION_IDENTIFIERS.get(mimeType), inputStream);
                Path tmp = Paths.get(fileName, new String[0]);
                String tmpName = tmp.getFileName().toString();
                int lastIndexOfPeriod = tmpName.lastIndexOf(46);
                if (lastIndexOfPeriod >= 0 && tmpName.length() > lastIndexOfPeriod) {
                    newFileName = tmpName.substring(0, lastIndexOfPeriod);
                    suffix = tmpName.substring(lastIndexOfPeriod);
                } else {
                    newFileName = "";
                    suffix = tmpName;
                }
                if (SUFFIX_TGZ.equalsIgnoreCase(suffix)) {
                    newFileName = String.valueOf(newFileName) + SUFFIX_TAR;
                }
                Path tmpFile = this.writeTempFile((InputStream)compressorInputStream, newFileName, tmpDir);
                String id = this.computeId(newCompoundList, newFileName);
                Record extractedCompoundRecord = record.getFactory().createRecord(id);
                extractedCompoundRecord.getMetadata().put("size", (Number)Files.size(tmpFile));
                extractedCompoundRecord.getMetadata().put("fileName", newFileName);
                if (record.getMetadata().containsKey((Object)"time")) {
                    extractedCompoundRecord.getMetadata().put("time", (Any)record.getMetadata().get((Object)"time"));
                }
                extractedCompoundRecord.getMetadata().put("compounds", AnyUtil.objectToAny(newCompoundList));
                try {
                    Throwable throwable = null;
                    Object var19_36 = null;
                    try (InputStream fis = Files.newInputStream(tmpFile, new OpenOption[0]);){
                        records.addAll(this.extractCompoundStream(fis, extractedCompoundRecord, newFileName, this.determineMimeType(newFileName, null), tmpDir, newCompoundList));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                finally {
                    Files.deleteIfExists(tmpFile);
                }
            }
            catch (IOException e) {
                this._log.warn((Object)("Cannot decompress compressed file '" + fileName + "'."), (Throwable)e);
            }
            catch (CompressorException e) {
                this._log.warn((Object)("Cannot decompress compressed file '" + fileName + "'."), (Throwable)e);
            }
        } else {
            try {
                Path tmpFile = this.writeTempFile(inputStream, fileName, tmpDir);
                record.getMetadata().put(KEY_TMP_FILE_NAME, tmpFile.toRealPath(new LinkOption[0]).toString());
                record.getMetadata().put("size", (Number)Files.size(tmpFile));
            }
            catch (IOException e) {
                this._log.warn((Object)("Cannot store compound content '" + fileName + "'."), (Throwable)e);
            }
        }
        return records;
    }

    private Path writeTempFile(InputStream inputStream, String newFileName, Path tmpDir) throws IOException {
        Path tmpFile = tmpDir.resolve(String.valueOf(UUID.randomUUID().toString()) + newFileName);
        if (!Files.exists(tmpFile.getParent(), new LinkOption[0])) {
            Files.createDirectories(tmpFile.getParent(), new FileAttribute[0]);
        }
        Files.copy(inputStream, tmpFile, new CopyOption[0]);
        return tmpFile;
    }

    private String computeId(List<String> newCompoundList, String name) {
        StringBuilder idBuilder = new StringBuilder();
        for (String compound : newCompoundList) {
            idBuilder.append(compound).append('/');
        }
        idBuilder.append(name);
        return idBuilder.toString();
    }

    public void setMimeTypeIdentifier(MimeTypeIdentifier mimeTypeIdentifier) {
        this._mimeTypeIdentifier = mimeTypeIdentifier;
    }

    public void unsetMimeTypeIdentifier(MimeTypeIdentifier mimeTypeIdentifier) {
        if (this._mimeTypeIdentifier == mimeTypeIdentifier) {
            this._mimeTypeIdentifier = null;
        }
    }
}

