/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.impl;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Attachment;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.InMemoryAttachment;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.impl.AnyMapImpl;
import org.eclipse.smila.datamodel.impl.DefaultDataFactoryImpl;
import org.eclipse.smila.datamodel.impl.ValueImpl;

public class RecordImpl
implements Record,
Serializable {
    private static final long serialVersionUID = 1L;
    private final AnyMap _metadata;
    private final Map<String, Attachment> _attachments = new LinkedHashMap<String, Attachment>();

    RecordImpl() {
        this._metadata = new AnyMapImpl();
    }

    RecordImpl(AnyMap metadata) {
        this._metadata = metadata;
    }

    @Override
    public String getId() {
        return this._metadata.getStringValue("_recordid");
    }

    @Override
    public String getSource() {
        return this._metadata.getStringValue("_source");
    }

    @Override
    public AnyMap getMetadata() {
        return this._metadata;
    }

    @Override
    public int attachmentSize() {
        return this._attachments.size();
    }

    @Override
    public Attachment getAttachment(String name) {
        return this._attachments.get(name);
    }

    @Override
    public byte[] getAttachmentAsBytes(String name) {
        if (this.hasAttachment(name)) {
            return this._attachments.get(name).getAsBytes();
        }
        return null;
    }

    @Override
    public Iterator<String> getAttachmentNames() {
        return this._attachments.keySet().iterator();
    }

    @Override
    public boolean hasAttachments() {
        return !this._attachments.isEmpty();
    }

    @Override
    public boolean hasAttachment(String name) {
        return this._attachments.containsKey(name);
    }

    @Override
    public void removeAttachment(String name) {
        Attachment removed = this._attachments.remove(name);
        if (removed != null) {
            removed.dispose();
        }
    }

    @Override
    public void removeAttachments() {
        for (Attachment attachment : this._attachments.values()) {
            attachment.dispose();
        }
        this._attachments.clear();
    }

    @Override
    public void setAttachment(Attachment attachment) {
        Attachment oldAttachment = this._attachments.put(attachment.getName(), attachment);
        if (oldAttachment != null) {
            oldAttachment.dispose();
        }
    }

    @Override
    public void setAttachment(String name, byte[] attachment) {
        this._attachments.put(name, new InMemoryAttachment(name, attachment));
    }

    @Override
    public void setId(String id) {
        if (id != null) {
            this._metadata.put("_recordid", new ValueImpl(Any.ValueType.STRING, id));
        }
    }

    @Override
    public void setSource(String source) {
        if (source != null) {
            this._metadata.put("_source", new ValueImpl(Any.ValueType.STRING, source));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this._metadata);
        if (this.hasAttachments()) {
            builder.append(" + ").append(this._attachments.keySet());
        }
        return builder.toString();
    }

    @Override
    public DataFactory getFactory() {
        return DefaultDataFactoryImpl.INSTANCE;
    }
}

