/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.impl;

import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.collections.iterators.SingletonIterator;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.datamodel.ValueFormatHelper;
import org.eclipse.smila.datamodel.impl.AbstractAny;
import org.eclipse.smila.datamodel.impl.AnySeqImpl;
import org.eclipse.smila.datamodel.impl.DateValue;

public final class ValueImpl
extends AbstractAny
implements Value {
    private static final long serialVersionUID = 1L;
    private final Object _value;

    ValueImpl(Any.ValueType valueType, Object value) {
        super(valueType);
        if (value == null) {
            throw new IllegalArgumentException("The value of any Any must not be null.");
        }
        this._value = value instanceof Date ? new DateValue((Date)value) : value;
    }

    ValueImpl(Value object) {
        super(object.getValueType());
        if (object instanceof ValueImpl) {
            this._value = ((ValueImpl)object)._value;
        } else {
            switch (object.getValueType()) {
                case BOOLEAN: {
                    this._value = object.asBoolean();
                    break;
                }
                case DATE: {
                    this._value = new DateValue(object.asDate());
                    break;
                }
                case DATETIME: {
                    this._value = new DateValue(object.asDateTime());
                    break;
                }
                case DOUBLE: {
                    this._value = object.asDouble();
                    break;
                }
                case LONG: {
                    this._value = object.asLong();
                    break;
                }
                case STRING: {
                    this._value = object.asString();
                    break;
                }
                default: {
                    throw new InvalidValueTypeException("Value of type '" + (Object)((Object)object.getValueType()) + "' cannot be copied.");
                }
            }
        }
    }

    @Override
    public Double asDouble() {
        if (this._valueType == Any.ValueType.DOUBLE) {
            return (Double)this._value;
        }
        if (this._valueType == Any.ValueType.LONG) {
            return ((Number)this._value).doubleValue();
        }
        if (this._valueType == Any.ValueType.STRING) {
            try {
                return Double.valueOf((String)this._value);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidValueTypeException("Value '" + this._value + "' of type '" + (Object)((Object)this._valueType) + "' cannot be converted to double.");
            }
        }
        throw new InvalidValueTypeException("Value of type '" + (Object)((Object)this._valueType) + "' cannot be converted to double.");
    }

    @Override
    public Long asLong() {
        if (this._valueType == Any.ValueType.LONG) {
            return (Long)this._value;
        }
        if (this._valueType == Any.ValueType.DOUBLE) {
            return ((Number)this._value).longValue();
        }
        if (this._valueType == Any.ValueType.STRING) {
            try {
                return Long.valueOf((String)this._value);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidValueTypeException("Value '" + this._value + "' of type '" + (Object)((Object)this._valueType) + "' cannot be converted to long.");
            }
        }
        throw new InvalidValueTypeException("Value of type '" + (Object)((Object)this._valueType) + "' cannot be converted to long.");
    }

    @Override
    public Boolean asBoolean() {
        if (this._valueType == Any.ValueType.BOOLEAN) {
            return (Boolean)this._value;
        }
        if (this._valueType == Any.ValueType.STRING) {
            return Boolean.valueOf((String)this._value);
        }
        throw new InvalidValueTypeException("Value of type '" + (Object)((Object)this._valueType) + "' cannot be converted to boolean.");
    }

    @Override
    public Date asDate() {
        if (this._valueType == Any.ValueType.DATE || this._valueType == Any.ValueType.DATETIME) {
            return new Date(((DateValue)this._value).getTime());
        }
        if (this._valueType == Any.ValueType.STRING) {
            try {
                return ValueFormatHelper.INSTANCE.parseDate((String)this._value);
            }
            catch (ParseException parseException) {
                throw new InvalidValueTypeException("Value '" + this._value + "' of type '" + (Object)((Object)this._valueType) + "' cannot be converted to date.");
            }
        }
        throw new InvalidValueTypeException("Value of type '" + (Object)((Object)this._valueType) + "' cannot be converted to Date.");
    }

    @Override
    public Date asDateTime() {
        if (this._valueType == Any.ValueType.DATE || this._valueType == Any.ValueType.DATETIME) {
            return new Date(((DateValue)this._value).getTime());
        }
        if (this._valueType == Any.ValueType.STRING) {
            try {
                return ValueFormatHelper.INSTANCE.parseDateTime((String)this._value);
            }
            catch (ParseException parseException) {
                throw new InvalidValueTypeException("Value '" + this._value + "' of type '" + (Object)((Object)this._valueType) + "' cannot be converted to datetime.");
            }
        }
        throw new InvalidValueTypeException("Value of type '" + (Object)((Object)this._valueType) + "' cannot be converted to DateTime.");
    }

    @Override
    public String asString() {
        if (this._value == null) {
            return null;
        }
        switch (this._valueType) {
            case STRING: {
                return (String)this._value;
            }
            case DATE: 
            case DATETIME: {
                return this.getDateString((DateValue)this._value);
            }
        }
        return this._value.toString();
    }

    private String getDateString(DateValue pair) {
        if (pair.hasOriginalString()) {
            return pair.getOriginalString();
        }
        if (this._valueType == Any.ValueType.DATE) {
            return ValueFormatHelper.INSTANCE.formatDate(pair.getDate());
        }
        return ValueFormatHelper.INSTANCE.formatDateTime(pair.getDate());
    }

    @Override
    public Object getObject() {
        if (this._valueType == Any.ValueType.DATE || this._valueType == Any.ValueType.DATETIME) {
            return ((DateValue)this._value).getDate();
        }
        return this._value;
    }

    public String toString() {
        if (this._value == null) {
            return "(void)";
        }
        return this.asString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
        result = 31 * result + (this._valueType == null ? 0 : this._valueType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueImpl other = (ValueImpl)obj;
        if (this._value == null ? other._value != null : !this._value.equals(other._value)) {
            return false;
        }
        return !(this._valueType == null ? other._valueType != null : !this._valueType.equals((Object)other._valueType));
    }

    @Override
    public Iterator<Any> iterator() {
        return new SingletonIterator((Object)this);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Value asValue() {
        return this;
    }

    @Override
    public AnySeq asSeq() {
        AnySeqImpl seq = new AnySeqImpl();
        seq.add(this);
        return seq;
    }
}

