/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.net.URI;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.CorrelationSetWriteEvent;
import org.apache.ode.bpel.evt.PartnerLinkModificationEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.extension.ExtensionOperation;
import org.apache.ode.bpel.rtrep.common.extension.ExtensibilityQNames;
import org.apache.ode.bpel.rtrep.v2.ACTIVITY;
import org.apache.ode.bpel.rtrep.v2.ASSIGNMessages;
import org.apache.ode.bpel.rtrep.v2.ActivityInfo;
import org.apache.ode.bpel.rtrep.v2.CompensationHandler;
import org.apache.ode.bpel.rtrep.v2.CorrelationSetInstance;
import org.apache.ode.bpel.rtrep.v2.EvaluationContext;
import org.apache.ode.bpel.rtrep.v2.ExtensionContextImpl;
import org.apache.ode.bpel.rtrep.v2.LinkFrame;
import org.apache.ode.bpel.rtrep.v2.OAssign;
import org.apache.ode.bpel.rtrep.v2.OBase;
import org.apache.ode.bpel.rtrep.v2.OElementVarType;
import org.apache.ode.bpel.rtrep.v2.OExpression;
import org.apache.ode.bpel.rtrep.v2.OLink;
import org.apache.ode.bpel.rtrep.v2.OMessageVarType;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.apache.ode.bpel.rtrep.v2.OPropertyVarType;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.OdeInternalInstance;
import org.apache.ode.bpel.rtrep.v2.PartnerLinkInstance;
import org.apache.ode.bpel.rtrep.v2.ScopeFrame;
import org.apache.ode.bpel.rtrep.v2.VariableInstance;
import org.apache.ode.bpel.rtrep.v2.channels.FaultData;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class ASSIGN
extends ACTIVITY {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(ASSIGN.class);
    private static final ASSIGNMessages __msgs = (ASSIGNMessages)MessageBundle.getMessages(ASSIGNMessages.class);

    public ASSIGN(ActivityInfo activityInfo, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        super(activityInfo, scopeFrame, linkFrame);
    }

    public void run() {
        OAssign oAssign = this.getOAsssign();
        FaultData faultData = null;
        for (OAssign.OAssignOperation oAssignOperation : oAssign.operations) {
            try {
                if (oAssignOperation instanceof OAssign.Copy) {
                    this.copy((OAssign.Copy)oAssignOperation);
                    continue;
                }
                if (!(oAssignOperation instanceof OAssign.ExtensionAssignOperation)) continue;
                this.invokeExtensionAssignOperation((OAssign.ExtensionAssignOperation)oAssignOperation);
            }
            catch (FaultException faultException) {
                if (oAssignOperation instanceof OAssign.Copy && (((OAssign.Copy)oAssignOperation).ignoreMissingFromData && faultException.getQName().equals(this.getOAsssign().getOwner().constants.qnSelectionFailure) && faultException.getCause() != null && "ignoreMissingFromData".equals(faultException.getCause().getMessage()) || ((OAssign.Copy)oAssignOperation).ignoreUninitializedFromVariable && faultException.getQName().equals(this.getOAsssign().getOwner().constants.qnUninitializedVariable) && (faultException.getCause() == null || !"throwUninitializedToVariable".equals(faultException.getCause().getMessage())))) continue;
                faultData = this.createFault(faultException.getQName(), oAssignOperation, faultException.getMessage());
                break;
            }
            catch (ExternalVariableModuleException externalVariableModuleException) {
                __log.error((Object)"Exception while initializing external variable", (Throwable)externalVariableModuleException);
                this._self.parent.failure(externalVariableModuleException.toString(), null);
                return;
            }
        }
        if (faultData != null) {
            __log.error((Object)("Assignment Fault: " + faultData.getFaultName() + ",lineNo=" + faultData.getFaultLineNo() + ",faultExplanation=" + faultData.getExplanation()));
            this._self.parent.completed(faultData, CompensationHandler.emptySet());
        } else {
            this._self.parent.completed(null, CompensationHandler.emptySet());
        }
    }

    protected Log log() {
        return __log;
    }

    private OAssign getOAsssign() {
        return (OAssign)this._self.o;
    }

    private Node evalLValue(OAssign.LValue lValue) throws FaultException, ExternalVariableModuleException {
        OdeInternalInstance odeInternalInstance = this.getBpelRuntime();
        Node node = null;
        if (!(lValue instanceof OAssign.PartnerLinkRef)) {
            VariableInstance variableInstance = this._scopeFrame.resolve(lValue.getVariable());
            if (!odeInternalInstance.isVariableInitialized(variableInstance)) {
                Document document = DOMUtils.newDocument();
                Node node2 = lValue.getVariable().type.newInstance(document);
                if (node2.getNodeType() == 3) {
                    Element element = document.createElementNS(null, "temporary-simple-type-wrapper");
                    document.appendChild(element);
                    element.appendChild(node2);
                    node2 = element;
                } else {
                    document.appendChild(node2);
                }
                node = variableInstance.declaration.extVar != null ? this.initializeVariable(variableInstance, node2) : node2;
            } else {
                node = this.fetchVariableData(variableInstance, true);
            }
        }
        return node;
    }

    private Node evalRValue(OAssign.RValue rValue) throws FaultException, ExternalVariableModuleException {
        Node node;
        Object object;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Evaluating FROM expression \"" + rValue + "\"."));
        }
        if (rValue instanceof OAssign.DirectRef) {
            object = (OAssign.DirectRef)rValue;
            this.sendVariableReadEvent(this._scopeFrame.resolve(((OAssign.DirectRef)object).variable));
            Node node2 = this.fetchVariableData(this._scopeFrame.resolve(((OAssign.DirectRef)object).variable), false);
            node = DOMUtils.findChildByName((Element)((Element)node2), (QName)((OAssign.DirectRef)object).elName);
        } else if (rValue instanceof OAssign.VariableRef) {
            object = (OAssign.VariableRef)rValue;
            this.sendVariableReadEvent(this._scopeFrame.resolve(((OAssign.VariableRef)object).variable));
            Node node3 = this.fetchVariableData(this._scopeFrame.resolve(((OAssign.VariableRef)object).variable), false);
            node = this.evalQuery(node3, ((OAssign.VariableRef)object).part != null ? ((OAssign.VariableRef)object).part : ((OAssign.VariableRef)object).headerPart, ((OAssign.VariableRef)object).location, this.getEvaluationContext());
        } else if (rValue instanceof OAssign.PropertyRef) {
            object = (OAssign.PropertyRef)rValue;
            this.sendVariableReadEvent(this._scopeFrame.resolve(((OAssign.PropertyRef)object).variable));
            Node node4 = this.fetchVariableData(this._scopeFrame.resolve(((OAssign.PropertyRef)object).variable), false);
            node = this.evalQuery(node4, ((OAssign.PropertyRef)object).propertyAlias.part, ((OAssign.PropertyRef)object).propertyAlias.location, this.getEvaluationContext());
        } else if (rValue instanceof OAssign.PartnerLinkRef) {
            Node node5;
            object = (OAssign.PartnerLinkRef)rValue;
            PartnerLinkInstance partnerLinkInstance = this._scopeFrame.resolve(((OAssign.PartnerLinkRef)object).partnerLink);
            Node node6 = node5 = ((OAssign.PartnerLinkRef)object).isMyEndpointReference ? this.getBpelRuntime().fetchMyRoleEndpointReferenceData(partnerLinkInstance) : this.getBpelRuntime().fetchPartnerRoleEndpointReferenceData(partnerLinkInstance);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("RValue is a partner link, corresponding endpoint " + node5.getClass().getName() + " has value " + DOMUtils.domToString((Node)node5)));
            }
            node = node5;
        } else if (rValue instanceof OAssign.Expression) {
            object = ((OAssign.Expression)rValue).expression;
            List list = this.getBpelRuntime().getExpLangRuntime().evaluate((OExpression)object, this.getEvaluationContext());
            if (list.size() == 0) {
                String string = __msgs.msgRValueNoNodesSelected(((OBase)object).toString());
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(rValue + ": " + string));
                }
                throw new FaultException(this.getOAsssign().getOwner().constants.qnSelectionFailure, string, new Throwable("ignoreMissingFromData"));
            }
            if (list.size() > 1) {
                String string = __msgs.msgRValueMultipleNodesSelected(((OBase)object).toString());
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(rValue + ": " + string));
                }
                throw new FaultException(this.getOAsssign().getOwner().constants.qnSelectionFailure, string);
            }
            node = (Node)list.get(0);
        } else if (rValue instanceof OAssign.Literal) {
            Object object2;
            object = ((OAssign.Literal)rValue).getXmlLiteral().getDocumentElement();
            assert (object.getLocalName().equals("literal"));
            object.normalize();
            node = object.getFirstChild();
            if (node != null && node.getNodeType() == 3 && node.getTextContent().trim().length() == 0 && node.getNextSibling() != null) {
                node = node.getNextSibling();
            }
            if (node == null) {
                node = object.getOwnerDocument().createTextNode("");
            } else if (node.getNodeType() == 1) {
                for (object2 = node.getNextSibling(); object2 != null; object2 = object2.getNextSibling()) {
                    if (object2.getNodeType() != 1) continue;
                    String string = __msgs.msgLiteralContainsMultipleEIIs();
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)(rValue + ": " + string));
                    }
                    throw new FaultException(this.getOAsssign().getOwner().constants.qnSelectionFailure, string);
                }
            } else if (node.getNodeType() == 3) {
                for (object2 = node.getNextSibling(); object2 != null; object2 = object2.getNextSibling()) {
                    if (object2.getNodeType() != 1) continue;
                    String string = __msgs.msgLiteralContainsMixedContent();
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)(rValue + ": " + string));
                    }
                    throw new FaultException(this.getOAsssign().getOwner().constants.qnSelectionFailure, string);
                }
            }
            if (node == null) {
                object2 = __msgs.msgLiteralMustContainTIIorEII();
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(rValue + ": " + (String)object2));
                }
                throw new FaultException(this.getOAsssign().getOwner().constants.qnSelectionFailure, (String)object2);
            }
        } else {
            String string = __msgs.msgInternalError("Unknown RVALUE type: " + rValue);
            if (__log.isErrorEnabled()) {
                __log.error((Object)(rValue + ": " + string));
            }
            throw new FaultException(this.getOAsssign().getOwner().constants.qnSelectionFailure, string);
        }
        if (node == null) {
            object = __msgs.msgEmptyRValue();
            if (__log.isDebugEnabled()) {
                __log.debug((Object)(rValue + ": " + (String)object));
            }
            throw new FaultException(this.getOAsssign().getOwner().constants.qnSelectionFailure, (String)object);
        }
        switch (node.getNodeType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                object = __msgs.msgInvalidRValue();
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(rValue + ": " + (String)object));
                }
                throw new FaultException(this.getOAsssign().getOwner().constants.qnSelectionFailure, (String)object);
            }
        }
        return node;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void copy(OAssign.Copy copy) throws FaultException, ExternalVariableModuleException {
        VariableModificationEvent variableModificationEvent;
        block24: {
            Object object;
            Object object2;
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Assign.copy(" + copy + ")"));
            }
            if (copy.to instanceof OAssign.VariableRef && ((OAssign.VariableRef)copy.to).isMessageRef() || copy.from instanceof OAssign.VariableRef && ((OAssign.VariableRef)copy.from).isMessageRef()) {
                if (copy.to instanceof OAssign.VariableRef && ((OAssign.VariableRef)copy.to).isMessageRef() && copy.from instanceof OAssign.VariableRef && ((OAssign.VariableRef)copy.from).isMessageRef()) {
                    VariableInstance variableInstance = this._scopeFrame.resolve(copy.to.getVariable());
                    VariableInstance variableInstance2 = this._scopeFrame.resolve(((OAssign.VariableRef)copy.from).getVariable());
                    Element element = (Element)this.fetchVariableData(variableInstance2, false);
                    this.initializeVariable(variableInstance, element);
                    variableModificationEvent = new VariableModificationEvent(variableInstance.declaration.name);
                    variableModificationEvent.setNewValue((Node)element);
                    break block24;
                } else {
                    __log.fatal((Object)("Message/Non-Message Assignment, should be caught by compiler:" + copy));
                    throw new FaultException(copy.getOwner().constants.qnSelectionFailure, "Message/Non-Message Assignment:  " + copy);
                }
            }
            Node node = this.evalRValue(copy.from);
            Node node2 = this.evalLValue(copy.to);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("lvalue after eval " + node2));
                if (node2 != null) {
                    __log.debug((Object)("content " + DOMUtils.domToString((Node)node2)));
                }
            }
            Node node3 = node2;
            boolean bl = false;
            if (copy.to instanceof OAssign.DirectRef) {
                object2 = (OAssign.DirectRef)copy.to;
                object = DOMUtils.findChildByName((Element)((Element)node2), (QName)((OAssign.DirectRef)object2).elName);
                if (object == null) {
                    object = (Element)((Element)node2).appendChild(node2.getOwnerDocument().createElementNS(((OAssign.DirectRef)object2).elName.getNamespaceURI(), ((OAssign.DirectRef)object2).elName.getLocalPart()));
                }
                node3 = object;
            } else if (copy.to instanceof OAssign.VariableRef) {
                object2 = (OAssign.VariableRef)copy.to;
                if (((OAssign.VariableRef)object2).headerPart != null) {
                    bl = true;
                }
                node3 = this.evalQuery(node2, ((OAssign.VariableRef)object2).part != null ? ((OAssign.VariableRef)object2).part : ((OAssign.VariableRef)object2).headerPart, ((OAssign.VariableRef)object2).location, new EvaluationContextProxy(((OAssign.VariableRef)object2).getVariable(), node2));
            } else if (copy.to instanceof OAssign.PropertyRef) {
                object2 = (OAssign.PropertyRef)copy.to;
                node3 = this.evalQuery(node2, ((OAssign.PropertyRef)object2).propertyAlias.part, ((OAssign.PropertyRef)object2).propertyAlias.location, new EvaluationContextProxy(((OAssign.PropertyRef)object2).getVariable(), node2));
            } else if (copy.to instanceof OAssign.LValueExpression) {
                object2 = (OAssign.LValueExpression)copy.to;
                ((OAssign.LValueExpression)object2).setInsertMissingToData(copy.insertMissingToData);
                node3 = this.evalQuery(node2, null, ((OAssign.LValueExpression)object2).expression, new EvaluationContextProxy(((OAssign.LValueExpression)object2).getVariable(), node2));
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("lvaluePtr expr res " + node3));
                }
            }
            if (copy.to instanceof OAssign.PartnerLinkRef) {
                object2 = (OAssign.PartnerLinkRef)copy.to;
                object = this._scopeFrame.resolve(((OAssign.PartnerLinkRef)object2).partnerLink);
                this.replaceEndpointRefence((PartnerLinkInstance)object, node);
                variableModificationEvent = new PartnerLinkModificationEvent(((OAssign.PartnerLinkRef)copy.to).partnerLink.getName());
            } else if (copy.to.getVariable().type instanceof OPropertyVarType) {
                object2 = this._scopeFrame.resolve(copy.to.getVariable().name);
                object = new CorrelationKey(((CorrelationSetInstance)object2).declaration.getId(), new String[]{node.getTextContent()});
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Writing correlation " + ((CorrelationSetInstance)object2).getName() + " using value " + node.getTextContent()));
                }
                this.getBpelRuntime().writeCorrelation((CorrelationSetInstance)object2, (CorrelationKey)object);
                variableModificationEvent = new CorrelationSetWriteEvent(((CorrelationSetInstance)object2).declaration.name, (CorrelationKey)object);
            } else {
                if (copy.from instanceof OAssign.PartnerLinkRef && (node = this.getBpelRuntime().convertEndpointReference((Element)node, node3)).getNodeType() == 9) {
                    node = ((Document)node).getDocumentElement();
                }
                node2 = bl && node3.getParentNode().getNodeName().equals("message") && node.getNodeType() == 1 ? this.copyInto((Element)node2, (Element)node3, (Element)node) : (node.getNodeType() == 1 && node3.getNodeType() == 1 ? this.replaceElement((Element)node2, (Element)node3, (Element)node, copy.keepSrcElementName) : this.replaceContent(node2, node3, node.getTextContent()));
                object2 = this._scopeFrame.resolve(copy.to.getVariable());
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("ASSIGN Writing variable '" + ((VariableInstance)object2).declaration.name + "' value '" + DOMUtils.domToString((Node)node2) + "'"));
                }
                this.commitChanges((VariableInstance)object2, node2);
                variableModificationEvent = new VariableModificationEvent(((VariableInstance)object2).declaration.name);
                variableModificationEvent.setNewValue(node2);
            }
        }
        if (copy.debugInfo != null) {
            variableModificationEvent.setLineNo(copy.debugInfo.startLine);
        }
        this.sendEvent((ScopeEvent)variableModificationEvent);
    }

    Node fetchVariableData(VariableInstance variableInstance, boolean bl) throws FaultException {
        try {
            return super.fetchVariableData(variableInstance, bl);
        }
        catch (FaultException faultException) {
            FaultException faultException2;
            if (bl) {
                faultException2 = new FaultException(faultException.getQName(), faultException.getMessage(), new Throwable("throwUninitializedToVariable"));
            }
            throw faultException2;
        }
    }

    private void replaceEndpointRefence(PartnerLinkInstance partnerLinkInstance, Node node) throws FaultException {
        if (node.getNodeType() == 2) {
            throw new FaultException(this.getOAsssign().getOwner().constants.qnMismatchedAssignmentFailure, "Can't assign an attribute to an endpoint, you probably want to select the attribute text.");
        }
        if (node.getNodeType() == 3 || node.getNodeType() == 1 && !node.getLocalName().equals("service-ref")) {
            Document document = DOMUtils.newDocument();
            Element element = document.createElementNS("http://docs.oasis-open.org/wsbpel/2.0/serviceref", "service-ref");
            document.appendChild(element);
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                element.appendChild(document.importNode(node2, true));
            }
            node = element;
        }
        this.getBpelRuntime().writeEndpointReference(partnerLinkInstance, (Element)node);
    }

    private Element replaceElement(Element element, Element element2, Element element3, boolean bl) {
        Document document = element2.getOwnerDocument();
        Node node = element2.getParentNode();
        if (bl) {
            Element element4 = (Element)document.importNode(element3, true);
            node.replaceChild(element4, element2);
            return element == element2 ? element4 : element;
        }
        Element element5 = document.createElementNS(element2.getNamespaceURI(), element2.getLocalName());
        NodeList nodeList = element3.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            element5.appendChild(document.importNode(nodeList.item(i), true));
        }
        NamedNodeMap namedNodeMap = element3.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            String string;
            String string2;
            Attr attr = (Attr)namedNodeMap.item(i);
            if (attr.getName().startsWith("xmlns")) continue;
            element5.setAttributeNodeNS((Attr)document.importNode(namedNodeMap.item(i), true));
            int n = attr.getValue().indexOf(":");
            if (n <= 0 || (string2 = element3.lookupPrefix(string = attr.getValue().substring(0, n))) == null) continue;
            element5.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, string2);
        }
        node.replaceChild(element5, element2);
        DOMUtils.copyNSContext((Element)element2, (Element)element5);
        return element == element2 ? element5 : element;
    }

    private Element copyInto(Element element, Element element2, Element element3) {
        element2.appendChild(element2.getOwnerDocument().importNode(element3, true));
        return element;
    }

    private Node replaceContent(Node node, Node node2, String string) throws FaultException {
        Document document = node2.getOwnerDocument();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("lvaluePtr type " + node2.getNodeType()));
            __log.debug((Object)("lvaluePtr " + DOMUtils.domToString((Node)node2)));
            __log.debug((Object)("lvalue " + node));
            __log.debug((Object)("rvalue " + string));
        }
        switch (node2.getNodeType()) {
            case 1: {
                while (node2.hasChildNodes()) {
                    node2.removeChild(node2.getFirstChild());
                }
                node2.appendChild(document.createTextNode(string));
                if (!(node instanceof Text)) break;
                node = node2.getFirstChild();
                break;
            }
            case 3: {
                Text text = document.createTextNode(string);
                node2.getParentNode().replaceChild(text, node2);
                if (node.getNodeType() == 1) {
                    if (node.getFirstChild() == null) {
                        Text text2 = node.getOwnerDocument().createTextNode("");
                        node.appendChild(text2);
                    }
                    if (node.getFirstChild().getNodeType() == 3) {
                        node = node.getFirstChild();
                    }
                }
                if (node.getNodeType() != 3 || !((Text)node).getWholeText().equals(((Text)node2).getWholeText())) break;
                node = node2 = text;
                break;
            }
            case 2: {
                ((Attr)node2).setValue(string);
                break;
            }
            default: {
                String string2 = __msgs.msgInvalidLValue();
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(node2 + ": " + string2));
                }
                throw new FaultException(this.getOAsssign().getOwner().constants.qnSelectionFailure, string2);
            }
        }
        return node;
    }

    private Node evalQuery(Node node, OMessageVarType.Part part, OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        assert (node != null);
        if (part != null) {
            QName qName = new QName(null, part.name);
            Element element = DOMUtils.findChildByName((Element)((Element)node), (QName)qName);
            if (part.type instanceof OElementVarType) {
                QName qName2 = ((OElementVarType)part.type).elementType;
                element = DOMUtils.findChildByName((Element)element, (QName)qName2);
            } else if (part.type == null) {
                if (element != null && element.getNodeType() == 1 && element.getAttribute("headerPart") != null && DOMUtils.getTextContent((Node)element) == null) {
                    element = DOMUtils.getFirstChildElement((Element)element);
                }
                if (element == null) {
                    element = node.getOwnerDocument().createElementNS(null, part.name);
                    element.setAttribute("headerPart", "true");
                    node.appendChild(element);
                }
            }
            node = element;
        }
        if (oExpression != null) {
            node = evaluationContext.evaluateQuery(node, oExpression);
        }
        return node;
    }

    private void invokeExtensionAssignOperation(OAssign.ExtensionAssignOperation extensionAssignOperation) throws FaultException {
        ExtensionContextImpl extensionContextImpl = new ExtensionContextImpl(this._self, this._scopeFrame, this.getBpelRuntime());
        try {
            ExtensionOperation extensionOperation = this.getBpelRuntime().createExtensionActivityImplementation(extensionAssignOperation.extensionName);
            if (extensionOperation == null) {
                for (OProcess.OExtension oExtension : extensionAssignOperation.getOwner().mustUnderstandExtensions) {
                    if (!extensionAssignOperation.extensionName.getNamespaceURI().equals(oExtension.namespaceURI)) continue;
                    __log.warn((Object)("Lookup of extension activity " + extensionAssignOperation.extensionName + " failed."));
                    throw new FaultException(ExtensibilityQNames.UNKNOWN_EA_FAULT_NAME, "Lookup of extension activity " + extensionAssignOperation.extensionName + " failed. No implementation found.");
                }
                extensionContextImpl.complete();
                return;
            }
            extensionOperation.run((Object)extensionContextImpl, extensionAssignOperation.nestedElement.getElement());
        }
        catch (FaultException faultException) {
            __log.error((Object)faultException);
            extensionContextImpl.completeWithFault(faultException);
        }
    }

    private class EvaluationContextProxy
    implements EvaluationContext {
        private OScope.Variable _var;
        private Node _varNode;
        private Node _rootNode;
        private EvaluationContext _ctx;

        private EvaluationContextProxy(OScope.Variable variable, Node node) {
            this._var = variable;
            this._varNode = node;
            this._ctx = ASSIGN.this.getEvaluationContext();
        }

        public Node readVariable(OScope.Variable variable, OMessageVarType.Part part) throws FaultException {
            if (variable.name.equals(this._var.name)) {
                if (part == null) {
                    return this._varNode;
                }
                return this._ctx.getPartData((Element)this._varNode, part);
            }
            return this._ctx.readVariable(variable, part);
        }

        public String readMessageProperty(OScope.Variable variable, OProcess.OProperty oProperty) throws FaultException {
            return this._ctx.readMessageProperty(variable, oProperty);
        }

        public boolean isLinkActive(OLink oLink) throws FaultException {
            return this._ctx.isLinkActive(oLink);
        }

        public Node getRootNode() {
            return this._rootNode;
        }

        public Node evaluateQuery(Node node, OExpression oExpression) throws FaultException {
            this._rootNode = node;
            return ASSIGN.this.getBpelRuntime().getExpLangRuntime().evaluateNode(oExpression, this);
        }

        public Node getPartData(Element element, OMessageVarType.Part part) throws FaultException {
            return this._ctx.getPartData(element, part);
        }

        public Long getProcessId() {
            return this._ctx.getProcessId();
        }

        public boolean narrowTypes() {
            return false;
        }

        public URI getBaseResourceURI() {
            return this._ctx.getBaseResourceURI();
        }

        public Node getPropertyValue(QName qName) {
            return this._ctx.getPropertyValue(qName);
        }
    }
}

