/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.zookeeper;

import java.io.IOException;

import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.eclipse.smila.clusterconfig.ClusterConfigException;
import org.eclipse.smila.datamodel.AnyMap;

/**
 * Interface of ZooKeeper management service.
 */
public interface ZooKeeperService {
  /**
   * name of bundle.
   */
  String BUNDLE_ID = "org.eclipse.smila.zookeeper";

  /**
   * get zookeeper client, create if it doesn't exist.
   * 
   * @return client
   * @throws IOException
   *           error creating client
   * @throws ClusterConfigException
   *           if the cluster configuration cannot be read
   */
  ZooKeeper getClient() throws IOException, ClusterConfigException;

  /**
   * close the client quietly.
   */
  void closeClient();

  /**
   * @return number of nodes that may fail without ZooKeeper service stopping to work.
   */
  long getFailSafetyLevel();

  /**
   * @return zookeeper server/cluster state for monitoring.
   */
  AnyMap getServerState();

  /** @return 'true' if zookeeper (cluster) is in a state to answer requests, 'false' otherwise. */
  boolean isOperational();

  /**
   * wait until the zookeeper client is (re)connected.
   */
  void waitForClientConnected();

  /** register a watcher for ZooKeeper events. */
  void registerWatcher(final Watcher watcher);

  /** unregister a watcher for ZooKeeper events. */
  void unregisterWatcher(final Watcher watcher);
}
