/*********************************************************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *********************************************************************************************************************/
package org.eclipse.smila.utils.service;

import org.osgi.service.component.ComponentException;

/**
 * @author tmenzel
 * 
 */
public class ServiceNotBoundException extends ComponentException {

  /** serialVersionUID. */
  private static final long serialVersionUID = 1L;

  /**
   * @param message
   * @param cause
   */
  public ServiceNotBoundException(String message, Throwable cause) {
    super(message, cause);
  }

  /**
   * @param message
   */
  public ServiceNotBoundException(String message) {
    super(message);
  }

  /**
   * @param effectMessage
   */
  public ServiceNotBoundException(Class<?> serviceClass, String effectMessage) {
    super(effectMessage + " Missing Service is of Type: " + serviceClass.getName());
  }

  /**
   * @param cause
   */
  public ServiceNotBoundException(Throwable cause) {
    super(cause);
  }

}
