/*********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.importing.crawler.web;

import java.util.Collection;

import org.eclipse.smila.datamodel.Record;

/**
 * Produces resulting records from fetched input record. Implementations may map the fetched attributes of the input
 * record to output record attributes. It's also possible to split the input record to multiple output records, or to
 * filter out the input record and return an empty result.
 */
public interface RecordProducer {

  /** @return collection of records, maybe empty. May also return more than one if input record is split. */
  Collection<Record> produceRecords(final Record record, WebCrawlingContext context) throws WebCrawlerException;
}
