/**
 *
 */
package org.eclipse.smila.solr.administration;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.ipc.IpcAnyReader;
import org.eclipse.smila.solr.SolrConstants;

/**
 * @author pwissel
 *
 */
public class SchemaRequest {

  final HttpClient _httpClient;

  final String _restUri;

  public SchemaRequest(final HttpClient httpClient, final String restUri) {
    _httpClient = httpClient;
    _restUri = restUri;
  }

  public Any getAsAny(final String index, final Map<String, String[]> params, List<String> path)
    throws HttpException, IOException {
    final String uri = getUri(index, path);
    final GetMethod method = new GetMethod(uri);
    final NameValuePair[] nameValuePairs = getAsNameValuePairs(params);
    method.setQueryString(nameValuePairs);
    _httpClient.executeMethod(method);
    final InputStream response = method.getResponseBodyAsStream();
    return new IpcAnyReader().readJsonStream(response);
  }

  private String getUri(final String index, final List<String> path) {
    final StrBuilder uri = new StrBuilder(_restUri);
    path.add(0, index);
    uri.appendWithSeparators(path, SolrConstants.SLASH);
    return uri.toString();
  }

  private NameValuePair[] getAsNameValuePairs(final Map<String, String[]> params) {
    final NameValuePair[] nameValuePairs = new NameValuePair[params.size()];
    int index = 0;
    for (final Entry<String, String[]> param : params.entrySet()) {
      nameValuePairs[index] = new NameValuePair(param.getKey(), param.getValue()[0]);
      index++;
    }
    return nameValuePairs;
  }

}
