/**
 *
 */
package org.eclipse.smila.solr.httphandler;

import org.apache.solr.common.params.CollectionParams.CollectionAction;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.util.URLCreator;

/**
 * @author pwissel
 *
 */
public class CollectionAdminHandler extends AAdminHandler {

  @Override
  Any doGet(HttpExchange exchange, final String requestUri) throws Exception {
    final String requestHost = getRequestHost(exchange);
    final AnyMap result = FACTORY.createAnyMap();
    final AnySeq help = result.getSeq("usage", true);
    for (final CollectionAction value : CollectionAction.values()) {
      final AnyMap action = FACTORY.createAnyMap();
      action.put("name", value.name());
      final String rootContextPath = getRootContextPath();
      final String staticUriPart = getStaticUriPart(requestUri);
      final String uri = rootContextPath + staticUriPart;
      final String pathToAppent = value.toLower();
      final String url = URLCreator.create(requestHost, uri, pathToAppent).toString();
      action.put("url", url);
      help.add(action);
    }
    return result;
  }

}
