/**
 *
 */
package org.eclipse.smila.solr.httphandler;

import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.UnsupportedMethodException;
import org.eclipse.smila.solr.SolrConstants;
import org.eclipse.smila.solr.SolrOperationService;

/**
 * @author pwissel
 *
 */
public class SchemaHandler extends JsonRequestHandler {

  private final Log _log = LogFactory.getLog(getClass());

  private SolrOperationService _operationService;

  @Override
  public Object process(String method, String requestUri, Record inputRecord, HttpExchange exchange)
    throws Exception {
    Any result = null;
    switch (method) {
      case "GET":
        final String index = getIndex(requestUri);
        final Map<String, String[]> params = exchange.getParameterMap();
        final List<String> path = getPath(requestUri);
        result = _operationService.processSchemaRequest(index, params, path);
        break;
      default:
        throw new UnsupportedMethodException("HttpMethod: [GET]");
    }
    return result;
  }

  private String getIndex(final String requestUri) {
    final String staticUriParts = getStaticUriParts(requestUri);
    return StringUtils.remove(staticUriParts, SolrConstants.SLASH);
  }

  private List<String> getPath(final String requestUri) throws URISyntaxException {
    final List<String> dynamicUriParts = getDynamicUriParts(requestUri);
    final Iterator<String> iterator = dynamicUriParts.iterator();
    while (iterator.hasNext()) {
      if (StringUtils.isBlank(iterator.next())) {
        iterator.remove();
      }
    }
    return dynamicUriParts;
  }

  @Override
  protected boolean isValidMethod(final String method, final String requestUri) {
    return "GET".equals(method);
  }

  protected void bindSolrOperationService(final SolrOperationService operationService) {
    if (_log.isDebugEnabled()) {
      _log.debug("Bind SolrOperationService...");
    }
    _operationService = operationService;
  }

  protected void unbindSolrOperationService(final SolrOperationService operationService) {
    if (_operationService == operationService) {
      if (_log.isDebugEnabled()) {
        _log.debug("Unbind SolrOperationService...");
      }
      _operationService = null;
    }
  }

}
