/**
 *
 */
package org.eclipse.smila.solr.params;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.solr.common.params.CommonParams;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.search.api.QueryConstants;
import org.eclipse.smila.search.api.helper.QueryParameterAccessor;

/**
 * @author pwissel
 *
 */
public class QueryParams extends QueryParameterAccessor {

  public static final String QUERY = "query";

  /**
   * @param blackboard
   * @param queryRecordId
   */
  public QueryParams(Blackboard blackboard, String queryRecordId) {
    super(blackboard, queryRecordId);
  }

  /**
   * @param blackboard
   * @param configuration
   * @param queryRecordId
   */
  public QueryParams(Blackboard blackboard, AnyMap configuration, String queryRecordId) {
    super(blackboard, configuration, queryRecordId);
  }

  public int getStart() {
    return getIntParameter(QueryConstants.OFFSET, QueryConstants.DEFAULT_OFFSET);
  }

  public int getRows() {
    return getIntParameter(QueryConstants.MAXCOUNT, QueryConstants.DEFAULT_MAXCOUNT);
  }

  public String[] getFields() {
    final List<String> fields = getParameters(QueryConstants.RESULTATTRIBUTES);
    if (CollectionUtils.isNotEmpty(fields)) {
      return fields.toArray(new String[fields.size()]);
    }
    return ArrayUtils.EMPTY_STRING_ARRAY;
  }

  public Any getQueryObject() {
    return getParameterAny(QueryConstants.QUERY);
  }

  public AnyMap getNativeParams() {
    final Any solr = getParameterAny(SolrParams.SOLR_PARAMETER_ATTRIBUTE);
    if (solr != null && solr.isMap()) {
      return solr.asMap().getMap(QUERY);
    }
    return null;
  }

  public String getRequestHandler() {
    final AnyMap nativeParams = getNativeParams();
    if (nativeParams != null) {
      return nativeParams.getStringValue(CommonParams.QT);
    }
    return null;
  }

}
