/**
 *
 */
package org.eclipse.smila.solr.params;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.processing.parameters.ParameterAccessor;

/**
 * @author pwissel
 *
 */
public class SolrParams extends ParameterAccessor {

  public static final String SOLR_PARAMETER_ATTRIBUTE = "_solr";

  /**
   * instance initializer
   */
  {
    setParameterAttribute(SOLR_PARAMETER_ATTRIBUTE);
  }

  /**
   * @param configuration
   */
  public SolrParams(AnyMap configuration) {
    super(configuration);
  }

  /**
   * @param blackboard
   */
  public SolrParams(Blackboard blackboard) {
    super(blackboard);
  }

  /**
   * @param blackboard
   * @param configuration
   */
  public SolrParams(Blackboard blackboard, AnyMap configuration) {
    super(blackboard, configuration);
  }

  /**
   * @param blackboard
   * @param configuration
   * @param recordId
   */
  public SolrParams(Blackboard blackboard, AnyMap configuration, String recordId) {
    super(blackboard, configuration, recordId);
  }

  /**
   * @param blackboard
   * @param recordId
   */
  public SolrParams(Blackboard blackboard, String recordId) {
    super(blackboard, recordId);
  }

  public Any getSolrParam(final String category, final String name) {
    Any param = null;
    AnyMap params = null;
    if (_blackboard != null && _recordId != null) {
      try {
        final Record record = _blackboard.getRecord(_recordId);
        if (record != null) {
          params = record.getMetadata();
        }
      } catch (BlackboardAccessException e) {
        ; // ignore
      }
      if (params != null && _parametersAttribute != null) {
        params = params.getMap(SOLR_PARAMETER_ATTRIBUTE);
      }
      param = getSubParam(params, category, name);
    }
    if (param == null) {
      params = _config;
      param = getSubParam(params, category, name);
    }
    return param;
  }

  private Any getSubParam(AnyMap params, final String category, final String name) {
    if (params != null) {
      params = params.getMap(category);
      if (params != null) {
        return params.get(name);
      }
    }
    return null;
  }

  public AnyMap getSolrParamAsAnyMap(final String category, final String name) {
    final Any map = getSolrParam(category, name);
    if (map != null) {
      return map.asMap();
    }
    return null;
  }

  public AnySeq getSolrParamAsAnySeq(final String category, final String name) {
    final Any seq = getSolrParam(category, name);
    if (seq != null) {
      return seq.asSeq();
    }
    return null;
  }

  public Boolean getSolrParamAsBoolean(final String category, final String name) {
    final Any val = getSolrParam(category, name);
    if (val != null) {
      return val.asValue().asBoolean();
    }
    return null;
  }

  public Float getSolrParamAsFloat(final String category, final String name) {
    final Any val = getSolrParam(category, name);
    if (val != null) {
      return val.asValue().asDouble().floatValue();
    }
    return null;
  }

  public Integer getSolrParamAsInteger(final String category, final String name) {
    final Any val = getSolrParam(category, name);
    if (val != null) {
      return val.asValue().asLong().intValue();
    }
    return null;
  }

  public String getSolrParamAsString(final String category, final String name) {
    final Any val = getSolrParam(category, name);
    if (val != null) {
      return val.asValue().asString();
    }
    return null;
  }

  public static AnyMap getSolrParams(final Record record) {
    return record.getMetadata().getMap(SOLR_PARAMETER_ATTRIBUTE);
  }

}
