/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.http.client.attachments;

import java.util.Iterator;
import java.util.Map;

import org.apache.http.entity.mime.content.ContentBody;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.client.Attachments;

/**
 * Use this class to provide attachments from a Record to the {@link org.eclipse.smila.http.client.RestClient} for a
 * POST request.
 * 
 * @since 1.1.0
 */
public class RecordAttachments implements Attachments {

  private final AttachmentWrapper _wrapper = new AttachmentWrapper();

  /**
   * Create instance from a Record.
   * 
   * @param record
   *          record with attachments.
   * @throws org.eclipse.smila.datamodel.AttachmentException
   *           if the attachment content cannot be accessed.
   */
  public RecordAttachments(final Record record) {
    for (final Iterator<String> attachmentNames = record.getAttachmentNames(); attachmentNames.hasNext();) {
      final String attachmentName = attachmentNames.next();
      _wrapper.add(attachmentName, record.getAttachment(attachmentName).getAsStream());
    }
  }

  @Override
  public Map<String, ContentBody> getAttachmentParts() {
    return _wrapper.getAttachmentParts();
  }
}
