/**********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.taskworker;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.taskmanager.Task;

/**
 * Default TaskLogFactory implementation. Writes logging to standard log file.
 */
public class DefaultTaskLogFactory implements TaskLogFactory {
  /** local logger. */
  private final Log _log = LogFactory.getLog(TaskLog.class);

  @Override
  public TaskLog getTaskLog(final Task task) {
    return new TaskLog() {

      /** number of info loggings. */
      private int _infoCount;

      /** number of warn loggings. */
      private int _warnCount;

      /** number of error loggings. */
      private int _errorCount;

      @Override
      public void error(final String message, final AnyMap details) {
        _errorCount++;
        _log.error("Task " + task + ": " + message + "; Details: " + details);
      }

      @Override
      public void error(final String message, final Throwable error) {
        _errorCount++;
        _log.error("Task " + task + ": " + message, error);
      }

      @Override
      public void error(final String message) {
        _errorCount++;
        _log.error("Task " + task + ": " + message);
      }

      @Override
      public void warn(final String message, final AnyMap details) {
        _warnCount++;
        _log.warn("Task " + task + ": " + message + "; Details: " + details);
      }

      @Override
      public void warn(final String message, final Throwable error) {
        _warnCount++;
        _log.warn("Task " + task + ": " + message, error);
      }

      @Override
      public void warn(final String message) {
        _warnCount++;
        _log.warn("Task " + task + ": " + message);
      }

      @Override
      public void info(final String message, final AnyMap details) {
        _infoCount++;
        _log.info("Task " + task + ": " + message + "; Details: " + details);
      }

      @Override
      public void info(final String message, final Throwable error) {
        _infoCount++;
        _log.info("Task " + task + ": " + message, error);
      }

      @Override
      public void info(final String message) {
        _infoCount++;
        _log.info("Task " + task + ": " + message);
      }

      @Override
      public int getWarnCount() {
        return _warnCount;
      }

      @Override
      public int getInfoCount() {
        return _infoCount;
      }

      @Override
      public int getErrorCount() {
        return _errorCount;
      }
    };
  }
}
