/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager.exceptions;

/**
 * It is not allowed to start a job in the given mode. The job or workflow definition restricted the modes the job may
 * be started in but the job should be started in a different mode. This exception is not recoverable.
 */
public class JobRunModeNotAllowedException extends JobManagerException {

  /**
   * Is Serializable.
   */
  private static final long serialVersionUID = 1L;

  /**
   * Constructs a new JobModeNotAllowedException.
   */
  public JobRunModeNotAllowedException(final String message, final Throwable cause) {
    super(message, cause, false);
  }

  /**
   * Constructs a new JobModeNotAllowedException.
   */
  public JobRunModeNotAllowedException(final String message) {
    super(message, false);
  }
}
