/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.objectstore.filesystem;

import java.io.File;
import java.util.Date;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.objectstore.StoreObject;

/**
 * Represents basic information for an object in {@link SimpleObjectStoreService}.
 */
public class SimpleObjectInfo implements StoreObject {

  /** The ID of the object in {@link SimpleObjectStoreService}. */
  private final String _id;

  /** the size of the object in {@link SimpleObjectStoreService}. */
  private final long _size;

  /** the timestamp of the object in {@link SimpleObjectStoreService}. */
  private final Date _timestamp;

  /** constructor. */
  public SimpleObjectInfo(final File file, final String id) {
    _id = id;
    _size = file.length();
    _timestamp = new Date(file.lastModified());
  }

  /** {@inheritDoc} */
  @Override
  public String getId() {
    return _id;
  }

  /** {@inheritDoc} */
  @Override
  public long getSize() {
    return _size;
  }

  /** {@inheritDoc} */
  @Override
  public Date getTimestamp() {
    return new Date(_timestamp.getTime());
  }

  /** {@inheritDoc} */
  @Override
  public AnyMap toAny() {
    final AnyMap anyMap = DataFactory.DEFAULT.createAnyMap();
    anyMap.put(KEY_ID, _id);
    anyMap.put(KEY_SIZE, _size);
    anyMap.put(KEY_TIMESTAMP, DataFactory.DEFAULT.createDateTimeValue(_timestamp));
    return anyMap;
  }

}
