/*********************************************************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *********************************************************************************************************************/
package org.eclipse.smila.importing.util;

import java.io.IOException;
import java.nio.file.Path;

import org.apache.commons.io.FilenameUtils;

/** util class for normalizing file paths. */
public final class FilePathNormalizer {

  /** to avoid instantiiation. */
  private FilePathNormalizer() {
  }

  /**
   * @return normalized input (file) path.
   * @throws IOException
   */
  public static String getNormalizedPath(final Path input) throws IOException {
    final String path = input.toRealPath().toString();
    return getNormalizedPath(path);
  }

  /** @return normalized input (file) path. */
  public static String getNormalizedPath(final String input) {
    // C:\temp -> C:/temp
    // \temp -> /temp
    // /temp/ -> /temp
    final String normalizedPath = FilenameUtils.normalizeNoEndSeparator(input, true);
    return normalizedPath;
  }

}
