/**********************************************************************************************************************
 * Copyright (c) 2008, 2014 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: Juergen Schumacher (Empolis Information Management GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.scripting;

import java.util.Collection;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;

/**
 * Interface for services that processes records by using a script.
 */
public interface ScriptingEngine {

  /**
   * get the list of script descriptions. Each element is map containing at least the name of the script.
   *
   * @throws ScriptingEngineException
   *           failed to determine available scripts.
   * */
  AnySeq listScripts() throws ScriptingEngineException;

  /**
   * get the list of the names of all scripts.
   *
   * @throws ScriptingEngineException
   *           failed to determine available scripts.
   * */
  Collection<String> listScriptNames() throws ScriptingEngineException;

  /**
   * Processes given record using the specified script function.
   *
   * @param scriptFunction
   *          name of script function to use for processing. ("script.function")
   * @param record
   *          record to process.
   * @return Processed record. Does not have to be the same object as the input record, may be null
   * @throws ScriptingEngineException
   *           error processing the record.
   */
  Record callScript(String scriptFunction, Record record) throws ScriptingEngineException;

  /**
   * Processes given map object using the specified script function.
   *
   * @param scriptFunction
   *          name of script function to use for processing. ("script.function")
   * @param arguments
   *          object to process.
   * @return Processed object. Does not have to be the same object as the input arguments, may be null
   * @throws ScriptingEngineException
   *           error processing the record.
   */
  AnyMap callScript(String scriptFunction, AnyMap arguments) throws ScriptingEngineException;

  /**
   * Creates a new script executor.
   *
   * @return a ScriptExecutor
   * @throws ScriptingEngineException
   *           error creating the executor.
   */
  ScriptExecutor getScriptExecutor() throws ScriptingEngineException;
}
