/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.zookeeper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.eclipse.smila.utils.config.ConfigurationUpdateWatcher;
import org.eclipse.smila.zookeeper.ZkConcurrentMap;
import org.eclipse.smila.zookeeper.ZkConnection;
import org.eclipse.smila.zookeeper.ZooKeeperService;
import org.osgi.service.component.ComponentContext;

public class ZkConfigurationUpdateWatcher
implements ConfigurationUpdateWatcher,
Watcher {
    private static final String BASEPATH = "/smila/configversions/";
    private static final int POLL_INTERVAL = 60;
    private final Log _log = LogFactory.getLog(this.getClass());
    private ZooKeeperService _zkService;
    private ConfigurationUpdateWatcher.UpdateableService _service;
    private String _configType;
    private String _rootPath;
    private ZkConnection _zk;
    private ScheduledExecutorService _scheduler;
    private boolean _watcherStarted;
    private boolean _watcherInstalled;
    private ZkConcurrentMap _clusterVersions;
    private final Map<String, Integer> _localVersions = new HashMap<String, Integer>();

    public ZkConfigurationUpdateWatcher() {
    }

    public ZkConfigurationUpdateWatcher(ZooKeeperService zkService, String configType) {
        this._zkService = zkService;
        this._configType = configType;
    }

    public void setZkService(ZooKeeperService zkService) {
        this._zkService = zkService;
    }

    public void unsetZkService(ZooKeeperService zkService) {
        if (this._zkService == zkService) {
            this._zkService = null;
        }
    }

    public synchronized void registerService(ConfigurationUpdateWatcher.UpdateableService service) {
        this._service = service;
    }

    protected void activate(ComponentContext context) {
        try {
            this._configType = context.getProperties().get("configType").toString();
            this.initialize();
        }
        catch (KeeperException ex) {
            this._log.error((Object)("Failed to create znode " + this._rootPath + ", watcher service will be disfunctional."), (Throwable)ex);
        }
    }

    public void initialize() throws KeeperException {
        this._rootPath = BASEPATH + this._configType;
        this._zk = new ZkConnection(this._zkService);
        this._zk.ensurePathExists(this._rootPath);
        this._clusterVersions = new ZkConcurrentMap(this._zk, this._rootPath);
    }

    public synchronized boolean startWatching() {
        this._watcherStarted = true;
        this.reinstallWatch();
        return this._watcherInstalled;
    }

    public synchronized void stopWatching() {
        this._watcherStarted = false;
        this._watcherInstalled = false;
    }

    public void startPolling() {
        this.startPolling(60);
    }

    public synchronized void startPolling(int pollIntervalSeconds) {
        if (this._scheduler == null) {
            this._scheduler = Executors.newScheduledThreadPool(1);
            this._scheduler.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    ZkConfigurationUpdateWatcher.this.checkConfigVersions();
                    ZkConfigurationUpdateWatcher.this.installWatch();
                }
            }, pollIntervalSeconds, pollIntervalSeconds, TimeUnit.SECONDS);
            this._log.info((Object)("Started: polling for " + this._configType + " configuration updates each " + pollIntervalSeconds + " seconds."));
        }
    }

    public synchronized void stopPolling() {
        if (this._scheduler != null) {
            this._scheduler.shutdownNow();
            this._scheduler = null;
            this._log.info((Object)("Stopped watcher for " + this._configType + " configuration updates."));
        }
    }

    public synchronized void configLoadedOnStart(String configurationName, String timestamp) {
        try {
            this._clusterVersions.putIfAbsent(configurationName, timestamp);
            this._localVersions.put(configurationName, this._clusterVersions.getVersion(configurationName));
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Failed to initialize for configuration '" + configurationName + "'.");
        }
    }

    public synchronized void configUpdated(String configurationName, String timestamp) {
        try {
            Integer version;
            String oldTimestamp = this._clusterVersions.getString(configurationName);
            if (oldTimestamp == null) {
                this._clusterVersions.put(configurationName, timestamp);
                version = this._clusterVersions.getVersion(configurationName);
            } else {
                version = this._clusterVersions.replaceAndGetVersion(configurationName, oldTimestamp, timestamp);
                if (version == null) {
                    throw new RuntimeException("Failed to send update notification for configuration '" + configurationName + "'");
                }
            }
            this._localVersions.put(configurationName, version);
            this.sendNotification(String.valueOf(configurationName) + " updated at " + timestamp);
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Failed to update for configuration '" + configurationName + "'.");
        }
    }

    public synchronized void configDeleted(String configurationName) {
        try {
            this._clusterVersions.remove(configurationName);
            this._localVersions.remove(configurationName);
            this.sendNotification(String.valueOf(configurationName) + " deleted");
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Failed to update for configuration '" + configurationName + "'.");
        }
    }

    public synchronized void checkConfigVersions() {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("checking versions of " + this._configType + " configurations deployed in the cluster"));
        }
        try {
            HashSet<String> obsoleteConfigs = new HashSet<String>(this._localVersions.keySet());
            for (String configurationName : this._clusterVersions.keySet()) {
                obsoleteConfigs.remove(configurationName);
                this.checkConfigVersion(configurationName);
            }
            for (String obsoleteConfig : obsoleteConfigs) {
                this.deleteConfig(obsoleteConfig);
            }
        }
        catch (Exception ex) {
            this._log.warn((Object)("Error getting cluster versions of  " + this._configType + " configurations, maybe we are losing an update now. We'll retry later."), (Throwable)ex);
        }
    }

    private synchronized void checkConfigVersion(String configurationName) {
        try {
            Integer localVersion;
            Integer clusterVersion = this._clusterVersions.getVersion(configurationName);
            if (!(clusterVersion == null || (localVersion = this._localVersions.get(configurationName)) != null && clusterVersion.equals(localVersion))) {
                try {
                    this._service.synchronizeConfiguration(configurationName, false);
                    this._localVersions.put(configurationName, clusterVersion);
                }
                catch (Exception ex) {
                    this._log.warn((Object)("Error updating  " + this._configType + " configuration '" + configurationName + "', old version will stay active."), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            this._log.warn((Object)("Error getting cluster version of " + this._configType + " configuration '" + configurationName + "', maybe we are losing an update now."), (Throwable)ex);
        }
    }

    private synchronized void deleteConfig(String configurationName) {
        try {
            this._service.synchronizeConfiguration(configurationName, true);
            this._localVersions.remove(configurationName);
        }
        catch (Exception ex) {
            this._log.warn((Object)("Error deleting " + this._configType + " configuration '" + configurationName + "', old version will stay active."), (Throwable)ex);
        }
    }

    private void sendNotification(String text) {
        try {
            this._zk.setData(this._rootPath, text.getBytes("utf-8"));
        }
        catch (Exception ex) {
            this._log.warn((Object)("Failed to update notification " + this._rootPath + " for " + text + ". Watches may not be triggered, remove configuration updates may need more time."), (Throwable)ex);
        }
    }

    private synchronized void installWatch() {
        if (this._watcherStarted && !this._watcherInstalled) {
            try {
                this._zk.exists(this._rootPath, this);
                this._watcherInstalled = true;
            }
            catch (KeeperException ex) {
                this._log.warn((Object)("Starting to watch for updates failed, pipeline update notifications may take a bit longer: Could not install watch on znode" + this._rootPath), (Throwable)ex);
            }
        }
    }

    private synchronized void reinstallWatch() {
        this._watcherInstalled = false;
        this.installWatch();
    }

    public void process(WatchedEvent event) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("watch triggered for " + this._configType + ": " + event));
        }
        this.reinstallWatch();
        this.checkConfigVersions();
    }
}

